/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.ItemStyle;
import edu.hm.hafner.echarts.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class LabeledTreeMapNode {
    private final ItemStyle itemStyle;
    private final Label label;
    private final Label upperLabel;
    private final String id;
    private String name;
    private final List<String> values = new ArrayList<String>();
    private final List<LabeledTreeMapNode> children = new ArrayList<LabeledTreeMapNode>();

    public LabeledTreeMapNode(String id, String name) {
        this(id, name, "");
    }

    public LabeledTreeMapNode(String id, String name, String value) {
        this(id, name, "-", value, new String[0]);
    }

    public LabeledTreeMapNode(String id, String name, String color, String value, String ... additionalValues) {
        this(id, name, new ItemStyle(color), new Label(false, "#ffffff"), new Label(false, "#ffffff"), value, additionalValues);
    }

    public LabeledTreeMapNode(String id, String name, ItemStyle itemStyle, Label label, Label upperLabel, String value, String ... additionalValues) {
        this.id = id;
        this.name = name;
        this.itemStyle = itemStyle;
        this.label = label;
        this.upperLabel = upperLabel;
        this.values.add(value);
        this.values.addAll(Arrays.asList(additionalValues));
    }

    public List<String> getValue() {
        return List.copyOf(this.values);
    }

    public String getName() {
        return this.name;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    public Label getLabel() {
        return this.label;
    }

    public Label getUpperLabel() {
        return this.upperLabel;
    }

    public List<LabeledTreeMapNode> getChildren() {
        return List.copyOf(this.children);
    }

    public void insertNode(LabeledTreeMapNode node) {
        this.children.add(node);
    }

    public void collapseEmptyPackages() {
        while (this.children.size() == 1) {
            LabeledTreeMapNode singleChild = this.children.iterator().next();
            this.name = String.join((CharSequence)".", this.name, singleChild.getName());
            this.children.clear();
            this.children.addAll(singleChild.getChildren());
        }
    }

    public String toString() {
        return "'%s' (%s)".formatted(this.name, this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabeledTreeMapNode that = (LabeledTreeMapNode)o;
        return Objects.equals(this.itemStyle, that.itemStyle) && Objects.equals(this.label, that.label) && Objects.equals(this.upperLabel, that.upperLabel) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.itemStyle, this.label, this.upperLabel, this.id, this.name, this.values, this.children);
    }
}

