/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.line.LinesChartModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import io.jenkins.plugins.echarts.GenericBuildActionIterator;
import io.jenkins.plugins.util.BuildAction;
import io.jenkins.plugins.util.JobAction;
import java.util.Iterator;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class TrendChartJobAction<T extends BuildAction<?>>
extends JobAction<T>
implements AsyncConfigurableTrendChart {
    @NonNull
    public abstract String getUrlName();

    protected TrendChartJobAction(Job<?, ?> owner, Class<T> buildActionClass) {
        super(owner, buildActionClass);
    }

    @Override
    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        return new JacksonFacade().toJson(this.createChartModel(configuration));
    }

    protected abstract LinesChartModel createChartModel(String var1);

    @Override
    public boolean isTrendVisible() {
        return this.hasAtLeastTwoResults();
    }

    private boolean hasAtLeastTwoResults() {
        Iterable<BuildResult<T>> results = this.createBuildHistory();
        Iterator<BuildResult<T>> iterator = results.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return iterator.hasNext();
    }

    protected Iterable<? extends BuildResult<T>> createBuildHistory() {
        return () -> new GenericBuildActionIterator<BuildAction, BuildAction>(this.getBuildActionClass(), this.getLatestAction(), a -> this.getUrlName().equals(a.getUrlName()), a -> a);
    }
}

