/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class PathUtil {
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private static final String DRIVE_LETTER_PREFIX = "^[a-z]:/.*";

    public boolean exists(String fileName) {
        try {
            return Files.exists(Path.of(fileName, new String[0]), new LinkOption[0]);
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public boolean exists(String fileName, String directory) {
        return this.exists(this.createAbsolutePath(directory, fileName));
    }

    public String getAbsolutePath(String path) {
        try {
            return this.getAbsolutePath(Path.of(path, new String[0]));
        }
        catch (IllegalArgumentException ignored) {
            return this.makeUnixPath(path);
        }
    }

    public String getAbsolutePath(Path path) {
        try {
            return this.makeUnixPath(this.normalize(path).toString());
        }
        catch (IOException | IllegalArgumentException ignored) {
            return this.makeUnixPath(path.toString());
        }
    }

    public String getRelativePath(Path base, String path) {
        try {
            return this.getRelativePath(base, Path.of(path, new String[0]));
        }
        catch (IllegalArgumentException ignored) {
            return this.makeUnixPath(path);
        }
    }

    public String getRelativePath(String base, String path) {
        try {
            return this.getRelativePath(Path.of(base, new String[0]), Path.of(path, new String[0]));
        }
        catch (IllegalArgumentException ignored) {
            return this.makeUnixPath(path);
        }
    }

    public String getRelativePath(Path base, Path path) {
        try {
            Path normalizedBase = this.normalize(base);
            if (path.isAbsolute()) {
                return this.makeUnixPath(normalizedBase.relativize(this.normalize(path)).toString());
            }
            return this.makeUnixPath(normalizedBase.relativize(this.normalize(base.resolve(path))).toString());
        }
        catch (IOException | IllegalArgumentException exception) {
            return this.makeUnixPath(path.toString());
        }
    }

    public String getRelativePath(Path relative) {
        return this.makeUnixPath(relative.normalize().toString());
    }

    public String getRelativePath(String relative) {
        try {
            return this.getRelativePath(Path.of(relative, new String[0]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.makeUnixPath(relative);
        }
    }

    public String createAbsolutePath(@CheckForNull String directory, String fileName) {
        if (this.isAbsolute(fileName) || StringUtils.isBlank((CharSequence)directory)) {
            return this.makeUnixPath(fileName);
        }
        String path = this.makeUnixPath(Objects.requireNonNull(directory));
        String separator = path.endsWith(SLASH) ? "" : SLASH;
        try {
            String normalized = FilenameUtils.normalize((String)String.join((CharSequence)separator, path, fileName));
            return this.makeUnixPath(normalized == null ? fileName : normalized);
        }
        catch (IllegalArgumentException ignored) {
            return this.makeUnixPath(fileName);
        }
    }

    public boolean isAbsolute(String fileName) {
        try {
            URI uri = new URI(fileName);
            if (uri.isAbsolute()) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return FilenameUtils.getPrefixLength((String)fileName) > 0;
    }

    private Path normalize(Path path) throws IOException {
        return path.toAbsolutePath().normalize().toRealPath(LinkOption.NOFOLLOW_LINKS);
    }

    private String makeUnixPath(String fileName) {
        String unixStyle = fileName.replace(BACK_SLASH, SLASH);
        if (unixStyle.matches(DRIVE_LETTER_PREFIX)) {
            unixStyle = StringUtils.capitalize((String)unixStyle);
        }
        return unixStyle;
    }
}

