/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.Generated;
import java.io.Serializable;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;

public final class LineRange
implements Serializable {
    private static final long serialVersionUID = -4124143085672930110L;
    private final int start;
    private final int end;

    public LineRange(int line) {
        this(line, line);
    }

    public LineRange(int start, int end) {
        if (start <= 0) {
            this.start = 0;
            this.end = 0;
        } else if (start < end) {
            this.start = start;
            this.end = end;
        } else {
            this.start = end;
            this.end = start;
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public NavigableSet<Integer> getLines() {
        TreeSet<Integer> lines = new TreeSet<Integer>();
        for (int line = this.getStart(); line <= this.getEnd(); ++line) {
            lines.add(line);
        }
        return lines;
    }

    public boolean contains(int line) {
        return line >= this.start && line <= this.end;
    }

    public boolean isSingleLine() {
        return this.start == this.end;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineRange lineRange = (LineRange)o;
        return this.start == lineRange.start && this.end == lineRange.end;
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "[%d-%d]", this.start, this.end);
    }
}

