/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Run;
import java.util.Optional;

public class BuildResultNavigator {
    private static final String SLASH = "/";

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String currentAbsoluteBrowserUrl, String resultId, String selectedBuildDisplayName) {
        for (Run run = currentBuild.getParent().getLastBuild(); run != null; run = run.getPreviousBuild()) {
            if (!selectedBuildDisplayName.equals(run.getDisplayName())) continue;
            return this.getSameUrlForOtherBuild(currentBuild, currentAbsoluteBrowserUrl, resultId, run);
        }
        return Optional.empty();
    }

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String viewUrl, String resultId, Run<?, ?> selectedBuild) {
        String match = SLASH + currentBuild.getNumber() + SLASH + resultId;
        if (viewUrl.contains(match)) {
            return Optional.of(viewUrl.replaceFirst(match + ".*", SLASH + selectedBuild.getNumber() + SLASH + resultId));
        }
        return Optional.empty();
    }
}

