/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import org.apache.commons.lang3.StringUtils;

public class DetectIndent {
    public Indent detect(String input) {
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            String[] inputs;
            int size = 0;
            char indent = ' ';
            for (String line : inputs = input.split("(\r\n|\r|\n)")) {
                block5: for (int i = 0; i < line.length(); ++i) {
                    switch (line.charAt(i)) {
                        case '\t': {
                            ++size;
                            indent = '\t';
                            continue block5;
                        }
                        case ' ': {
                            indent = ' ';
                            ++size;
                            continue block5;
                        }
                        default: {
                            if (size == 0) continue block5;
                            return new Indent(size, indent);
                        }
                    }
                }
            }
        }
        return new Indent();
    }

    public class Indent {
        int size = 0;
        char type = (char)32;

        public Indent() {
        }

        public Indent(int size, char indent) {
            this.size = size;
            this.type = indent;
        }

        public String getIndent() {
            return StringUtils.repeat((String)String.valueOf(this.type), (int)this.size);
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public char getType() {
            return this.type;
        }

        public void setType(char type) {
            this.type = type;
        }
    }
}

