/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import com.google.common.collect.ImmutableSet;
import io.jenkins.tools.incrementals.maven.DetectIndent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="incrementalify", requiresDirectInvocation=true, aggregator=true)
public class IncrementalifyMojo
extends AbstractVersionsUpdaterMojo {
    private static final String MINIMUM_JENKINS_PARENT = "1.47";
    private static final String MINIMUM_PLUGIN_PARENT = "3.10";
    public static final String JENKINS_POM = "org.jenkins-ci:jenkins:pom";
    public static final String PLUGIN_POM = "org.jenkins-ci.plugins:plugin:pom";
    private static final Set<String> PARENT_DEPENDENCIES = ImmutableSet.of((Object)"org.jenkins-ci:jenkins:pom", (Object)"org.jenkins-ci.plugins:plugin:pom");
    @Component
    private BuildPluginManager pluginManager;
    private static final Pattern TEXT = Pattern.compile("(.+[:/])((?:[^/]+)/(?:[^/]+?))((?:[.]git)?)");

    @Inject
    public IncrementalifyMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        VersionRange any;
        ArtifactVersions gclmeVersions;
        File dotMvn = new File(this.project.getBasedir(), ".mvn");
        File extensionsXml = new File(dotMvn, "extensions.xml");
        if (extensionsXml.isFile()) {
            throw new MojoFailureException("Editing an existing " + String.valueOf(extensionsXml) + " is not yet supported");
        }
        try {
            gclmeVersions = this.getHelper().lookupArtifactVersions(this.getHelper().createDependencyArtifact("io.jenkins.tools.incrementals", "git-changelist-maven-extension", "[0,)", "type", null, null, false), true);
        }
        catch (VersionRetrievalException x) {
            throw new MojoExecutionException(x.getMessage(), (Exception)((Object)x));
        }
        try {
            any = VersionRange.createFromVersionSpec((String)"[0,)");
        }
        catch (InvalidVersionSpecificationException x) {
            throw new MojoExecutionException(x.getMessage(), (Exception)((Object)x));
        }
        ArtifactVersion gclmeNewestVersion = gclmeVersions.getNewestVersion(any, false);
        super.execute();
        this.project.getProperties().setProperty("dollar", "$");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.codehaus.mojo", (String)"versions-maven-plugin", (String)"2.5"), (String)"set", (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"newVersion", (String)"${dollar}{revision}${dollar}{changelist}"), MojoExecutor.element((String)"generateBackupPoms", (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        File mavenConfig = new File(dotMvn, "maven.config");
        try {
            String existing = mavenConfig.isFile() ? FileUtils.readFileToString((File)mavenConfig, (String)"UTF-8") : "";
            dotMvn.mkdirs();
            FileUtils.writeStringToFile((File)mavenConfig, (String)("-Pconsume-incrementals\n-Pmight-produce-incrementals\n" + existing), (String)"UTF-8");
            try (InputStream is = IncrementalifyMojo.class.getResourceAsStream("prototype-extensions.xml");){
                FileUtils.writeStringToFile((File)extensionsXml, (String)IOUtils.toString((InputStream)is).replace("@VERSION@", gclmeNewestVersion.toString()));
            }
        }
        catch (IOException x) {
            throw new MojoExecutionException("failed to update " + String.valueOf(dotMvn), (Exception)x);
        }
    }

    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        String version = PomHelper.getProjectVersion((MutableXMLStreamReader)pom);
        Matcher m = Pattern.compile("(.+)-SNAPSHOT").matcher(version);
        if (!m.matches()) {
            throw new MojoFailureException("Unexpected version: " + version);
        }
        String origTag = this.project.getScm().getTag();
        if (!origTag.equals("HEAD")) {
            throw new MojoFailureException("Unexpected tag: " + origTag);
        }
        Artifact parent = IncrementalifyMojo.getProjectParent(pom, this.getHelper());
        if (parent == null) {
            throw new MojoFailureException("No <parent> found");
        }
        if (!PARENT_DEPENDENCIES.contains(parent.getDependencyConflictId())) {
            throw new MojoFailureException("Unexpected <parent> " + String.valueOf(parent));
        }
        String connection = this.project.getScm().getConnection();
        String developerConnection = this.project.getScm().getDeveloperConnection();
        String url = this.project.getScm().getUrl();
        if (connection == null || developerConnection == null || url == null) {
            throw new MojoFailureException("<scm> must contain all of connection, developerConnection, and url");
        }
        ReplaceGitHubRepo connectionRGHR = IncrementalifyMojo.replaceGitHubRepo(connection);
        ReplaceGitHubRepo developerConnectionRGHR = IncrementalifyMojo.replaceGitHubRepo(developerConnection);
        ReplaceGitHubRepo urlRGHR = IncrementalifyMojo.replaceGitHubRepo(url);
        if (!developerConnectionRGHR.gitHubRepo.equals(connectionRGHR.gitHubRepo) || !urlRGHR.gitHubRepo.equals(connectionRGHR.gitHubRepo)) {
            throw new MojoFailureException("Mismatch among gitHubRepo parts of <scm>: " + connectionRGHR.gitHubRepo + " vs. " + developerConnectionRGHR.gitHubRepo + " vs. " + urlRGHR.gitHubRepo);
        }
        String minimum_parent = parent.getDependencyConflictId().equals(JENKINS_POM) ? MINIMUM_JENKINS_PARENT : MINIMUM_PLUGIN_PARENT;
        if (new ComparableVersion(parent.getVersion()).compareTo(new ComparableVersion(minimum_parent)) < 0) {
            PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)minimum_parent);
        }
        this.prependProperty(pom, "gitHubRepo", connectionRGHR.gitHubRepo);
        this.prependProperty(pom, "changelist", "-SNAPSHOT");
        this.prependProperty(pom, "revision", m.group(1));
        PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"tag", (String)"${scmTag}");
        PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"connection", (String)connectionRGHR.interpolableText);
        PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"developerConnection", (String)developerConnectionRGHR.interpolableText);
        PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"url", (String)urlRGHR.interpolableText);
    }

    private static Artifact getProjectParent(MutableXMLStreamReader pom, VersionsHelper helper) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        Object path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/parent((/groupId)|(/artifactId)|(/version))");
        String groupId = null;
        String artifactId = null;
        String version = null;
        pom.rewind();
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                stack.push((String)path);
                String elementName = pom.getLocalName();
                path = (String)path + "/" + elementName;
                if (matchScopeRegex.matcher((CharSequence)path).matches()) {
                    if ("groupId".equals(elementName)) {
                        groupId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        artifactId = pom.getElementText().trim();
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        version = pom.getElementText().trim();
                        path = (String)stack.pop();
                    }
                }
            }
            if (!pom.isEndElement()) continue;
            path = (String)stack.pop();
        }
        if (groupId == null || artifactId == null || version == null) {
            return null;
        }
        return helper.createDependencyArtifact(groupId, artifactId, version, "pom", null, null, false);
    }

    static ReplaceGitHubRepo replaceGitHubRepo(String text) throws MojoFailureException {
        Matcher m = TEXT.matcher(text);
        if (!m.matches()) {
            throw new MojoFailureException(text + " did not match " + String.valueOf(TEXT));
        }
        return new ReplaceGitHubRepo(m.group(1) + "${gitHubRepo}" + m.group(3), m.group(2));
    }

    private void prependProperty(MutableXMLStreamReader pom, String name, String value) throws XMLStreamException, MojoFailureException {
        Stack<String> stack = new Stack<String>();
        pom.rewind();
        boolean found = false;
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                stack.push(pom.getLocalName());
                if (!stack.equals(Arrays.asList("project", "properties"))) continue;
                pom.mark((Object)0);
                continue;
            }
            if (!pom.isEndElement()) continue;
            if (stack.equals(Arrays.asList("project", "properties"))) {
                pom.mark((Object)1);
                found = true;
                String orig = pom.getBetween((Object)0, (Object)1);
                DetectIndent.Indent indent = new DetectIndent().detect(orig);
                pom.replaceBetween((Object)0, (Object)1, "\n" + indent.getIndent() + "<" + name + ">" + value + "</" + name + ">" + orig);
                pom.clearMark((Object)0);
                pom.clearMark((Object)1);
            }
            stack.pop();
        }
        if (!found) {
            throw new MojoFailureException("failed to find <properties>");
        }
    }

    private static final class ReplaceGitHubRepo {
        final String interpolableText;
        final String gitHubRepo;

        ReplaceGitHubRepo(String interpolableText, String gitHubRepo) {
            this.interpolableText = interpolableText;
            this.gitHubRepo = gitHubRepo;
        }
    }
}

