/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.gson.io;

import com.google.gson.Gson;
import io.jsonwebtoken.gson.io.GsonSerializer;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;

public class GsonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final Gson gson;

    public GsonDeserializer() {
        this(GsonSerializer.DEFAULT_GSON);
    }

    public GsonDeserializer(Gson gson) {
        this(gson, Object.class);
    }

    private GsonDeserializer(Gson gson, Class<T> returnType) {
        Assert.notNull((Object)gson, (String)"gson cannot be null.");
        Assert.notNull(returnType, (String)"Return type cannot be null.");
        this.gson = gson;
        this.returnType = returnType;
    }

    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, (Throwable)e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return (T)this.gson.fromJson(new String(bytes, Strings.UTF_8), this.returnType);
    }
}

