/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.invoker.internal.KatharsisInvokerContext;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.invoker.internal.KatharsisInvokerV2;
import io.katharsis.module.Module;
import io.katharsis.queryspec.QuerySpecDeserializer;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.servlet.internal.FilterPropertiesProvider;
import io.katharsis.servlet.internal.ServletKatharsisInvokerContext;
import io.katharsis.servlet.internal.ServletModule;
import io.katharsis.servlet.internal.ServletUrlProvider;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KatharsisFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(KatharsisFilter.class);
    private ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();
    private ServletContext servletContext;
    private KatharsisInvokerV2 katharsisInvoker;
    private String filterBasePath;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        this.filterBasePath = filterConfig.getInitParameter("katharsis.config.web.path.prefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            req.setCharacterEncoding("UTF-8");
            KatharsisInvokerContext invokerContext = this.createKatharsisInvokerContext(request, response);
            this.requestThreadLocal.set(request);
            try {
                this.getKatharsisInvoker().invoke(invokerContext);
            }
            catch (KatharsisInvokerException e) {
                log.warn("Katharsis Invoker exception.", (Throwable)e);
                response.setStatus(e.getStatusCode());
            }
            catch (Exception e) {
                throw new ServletException("Katharsis invocation failed.", (Throwable)e);
            }
            finally {
                this.requestThreadLocal.remove();
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    protected KatharsisInvokerV2 createKatharsisInvoker() {
        ServletUrlProvider servletUrlProvider = new ServletUrlProvider(this.requestThreadLocal);
        KatharsisInvokerV2 invoker = new KatharsisInvokerV2();
        invoker.setPropertiesProvider(new FilterPropertiesProvider(this.filterConfig));
        invoker.getBoot().setDefaultServiceUrlProvider((ServiceUrlProvider)servletUrlProvider);
        invoker.addModule(new ServletModule(this.requestThreadLocal));
        return invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KatharsisInvokerV2 getKatharsisInvoker() {
        KatharsisInvokerV2 invoker = this.katharsisInvoker;
        if (invoker == null) {
            KatharsisFilter katharsisFilter = this;
            synchronized (katharsisFilter) {
                invoker = this.katharsisInvoker;
                if (invoker == null) {
                    invoker = this.createKatharsisInvoker();
                    invoker.configure();
                    this.katharsisInvoker = invoker;
                }
            }
        }
        return invoker;
    }

    public void setKatharsisInvoker(KatharsisInvokerV2 katharsisInvoker) {
        this.katharsisInvoker = katharsisInvoker;
    }

    public void addModule(Module module) {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        invoker.addModule(module);
    }

    public ObjectMapper getObjectMapper() {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        return invoker.getObjectMapper();
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        invoker.setDefaultPageLimit(defaultPageLimit);
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        return invoker.getQuerySpecDeserializer();
    }

    public String getFilterBasePath() {
        return this.filterBasePath;
    }

    public void setFilterBasePath(String filterBasePath) {
        this.filterBasePath = filterBasePath;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    protected KatharsisInvokerContext createKatharsisInvokerContext(HttpServletRequest request, HttpServletResponse response) {
        return new ServletKatharsisInvokerContext(this.getServletContext(), request, response){

            @Override
            public String getRequestPath() {
                String path = super.getRequestPath();
                if (KatharsisFilter.this.filterBasePath != null && path.startsWith(KatharsisFilter.this.filterBasePath)) {
                    path = path.substring(KatharsisFilter.this.filterBasePath.length());
                }
                return path;
            }
        };
    }
}

