/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet.internal;

import io.katharsis.errorhandling.exception.ParametersDeserializationException;
import io.katharsis.invoker.internal.KatharsisInvokerContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class QueryStringUtils {
    private static final String QUERY_CHARSET = StandardCharsets.UTF_8.name();

    private QueryStringUtils() {
    }

    public static Map<String, Set<String>> parseQueryStringAsSingleValueMap(KatharsisInvokerContext invokerContext) {
        try {
            return QueryStringUtils.buildSingleQueryParams(invokerContext);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParametersDeserializationException("Couldn't decode param: " + e.getMessage());
        }
    }

    private static Map<String, Set<String>> buildSingleQueryParams(KatharsisInvokerContext invokerContext) throws UnsupportedEncodingException {
        Map<String, Set<String>> queryParamMap;
        String queryString = invokerContext.getRequestQueryString();
        if (queryString == null) {
            queryParamMap = Collections.emptyMap();
        } else {
            queryParamMap = new LinkedHashMap();
            String[] paramPairs = queryString.split("&");
            for (String paramPair : paramPairs) {
                String[] paramNameAndValue = paramPair.split("=");
                if (paramNameAndValue.length <= 1) continue;
                String paramName = QueryStringUtils.decode(paramNameAndValue[0]);
                queryParamMap.put(paramName, null);
            }
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String[] queryParameter = invokerContext.getQueryParameterValues((String)entry.getKey());
                if (queryParameter == null) continue;
                entry.setValue(new HashSet<String>(Arrays.asList(queryParameter)));
            }
        }
        return queryParamMap;
    }

    public static Map<String, String[]> parseQueryStringAsMultiValuesMap(KatharsisInvokerContext invokerContext) {
        try {
            return QueryStringUtils.buildMultiQueryParams(invokerContext);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParametersDeserializationException("Couldn't decode param: " + e.getMessage());
        }
    }

    private static Map<String, String[]> buildMultiQueryParams(KatharsisInvokerContext invokerContext) throws UnsupportedEncodingException {
        Map<String, String[]> queryParamMap;
        String queryString = invokerContext.getRequestQueryString();
        if (queryString == null) {
            queryParamMap = Collections.emptyMap();
        } else {
            queryParamMap = new LinkedHashMap();
            String[] paramPairs = queryString.split("&");
            for (String paramPair : paramPairs) {
                String paramName;
                String[] paramNameAndValue = paramPair.split("=");
                if (paramNameAndValue.length <= 1 || (paramName = QueryStringUtils.decode(paramNameAndValue[0].trim())).length() == 0) continue;
                queryParamMap.put(paramName, null);
            }
            for (Map.Entry entry : queryParamMap.entrySet()) {
                LinkedList<String> decodedParameterValueList = new LinkedList<String>();
                for (String parameterValue : invokerContext.getQueryParameterValues((String)entry.getKey())) {
                    if (parameterValue == null) continue;
                    decodedParameterValueList.add(parameterValue);
                }
                entry.setValue(decodedParameterValueList.toArray(new String[decodedParameterValueList.size()]));
            }
        }
        return queryParamMap;
    }

    private static String decode(String key) throws UnsupportedEncodingException {
        return URLDecoder.decode(key, QUERY_CHARSET);
    }
}

