/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet.legacy;

import io.katharsis.invoker.internal.KatharsisInvokerContext;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.invoker.internal.legacy.KatharsisInvoker;
import io.katharsis.invoker.internal.legacy.KatharsisInvokerBuilder;
import io.katharsis.servlet.internal.ServletKatharsisInvokerContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKatharsisFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(AbstractKatharsisFilter.class);
    private ServletContext servletContext;
    private volatile KatharsisInvoker katharsisInvoker;
    private String filterBasePath;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.filterBasePath = filterConfig.getInitParameter("katharsis.config.web.path.prefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            req.setCharacterEncoding("UTF-8");
            KatharsisInvokerContext invokerContext = this.createKatharsisInvokerContext(request, response);
            try {
                this.getKatharsisInvoker().invoke(invokerContext);
            }
            catch (KatharsisInvokerException e) {
                log.warn("Katharsis Invoker exception.", (Throwable)e);
                response.setStatus(e.getStatusCode());
            }
            catch (Exception e) {
                throw new ServletException("Katharsis invocation failed.", (Throwable)e);
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KatharsisInvoker getKatharsisInvoker() throws Exception {
        KatharsisInvoker invoker = this.katharsisInvoker;
        if (invoker == null) {
            AbstractKatharsisFilter abstractKatharsisFilter = this;
            synchronized (abstractKatharsisFilter) {
                invoker = this.katharsisInvoker;
                if (invoker == null) {
                    this.katharsisInvoker = invoker = this.createKatharsisInvoker();
                }
            }
        }
        return invoker;
    }

    public void setKatharsisInvoker(KatharsisInvoker katharsisInvoker) {
        this.katharsisInvoker = katharsisInvoker;
    }

    public String getFilterBasePath() {
        return this.filterBasePath;
    }

    public void setFilterBasePath(String filterBasePath) {
        this.filterBasePath = filterBasePath;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    protected KatharsisInvokerContext createKatharsisInvokerContext(HttpServletRequest request, HttpServletResponse response) {
        return new ServletKatharsisInvokerContext(this.getServletContext(), request, response){

            @Override
            public String getRequestPath() {
                String path = super.getRequestPath();
                if (AbstractKatharsisFilter.this.filterBasePath != null && path.startsWith(AbstractKatharsisFilter.this.filterBasePath)) {
                    path = path.substring(AbstractKatharsisFilter.this.filterBasePath.length());
                }
                return path;
            }
        };
    }

    protected KatharsisInvoker createKatharsisInvoker() throws Exception {
        return this.createKatharsisInvokerBuilder().build();
    }

    protected abstract KatharsisInvokerBuilder createKatharsisInvokerBuilder();
}

