/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.jetty;

import io.ktor.client.engine.jetty.JettyHttp2RequestKt;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.util.Callback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0019\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lio/ktor/client/engine/jetty/JettyHttp2Request;", "Lorg/eclipse/jetty/util/Callback;", "stream", "Lorg/eclipse/jetty/http2/api/Stream;", "(Lorg/eclipse/jetty/http2/api/Stream;)V", "deferred", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/CompletableDeferred;", "", "endBody", "failed", "cause", "", "succeeded", "write", "src", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-client-jetty"})
public final class JettyHttp2Request
implements Callback {
    private final AtomicReference<CompletableDeferred<Unit>> deferred;
    private final Stream stream;

    @Nullable
    public final Object write(@NotNull ByteBuffer src, @NotNull Continuation<? super Unit> continuation) {
        CompletableDeferred result = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.deferred.set((CompletableDeferred<Unit>)result);
        DataFrame frame = new DataFrame(this.stream.getId(), src, false);
        this.stream.data(frame, (Callback)this);
        return result.await(continuation);
    }

    public void succeeded() {
        Object v0 = this.deferred.getAndSet(null);
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        ((CompletableDeferred)v0).complete((Object)Unit.INSTANCE);
    }

    public void failed(@NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        Object v0 = this.deferred.getAndSet(null);
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        ((CompletableDeferred)v0).completeExceptionally(cause);
    }

    public final void endBody() {
        this.stream.data(new DataFrame(this.stream.getId(), JettyHttp2RequestKt.access$getEmptyByteBuffer$p(), true), Callback.NOOP);
    }

    public JettyHttp2Request(@NotNull Stream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        this.stream = stream;
        this.deferred = new AtomicReference();
    }
}

