/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.Counterparty;
import io.ktor.network.tls.certificates.KeyType;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.CloseableJVMKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002\u001aN\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002\u001a\f\u0010!\u001a\u00020\u001f*\u00020 H\u0002\u001a\f\u0010\"\u001a\u00020\u001b*\u00020\u001bH\u0002\u001a%\u0010#\u001a\u00020\u001f*\u00020 2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001af\u0010\u0014\u001a\u00020\u0003*\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010'\u001a\u00020\u000f2\b\b\u0002\u0010(\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010)\u001a\u00020\u001f*\u00020 H\u0002\u001a(\u0010*\u001a\u00020\u001f*\u00020 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0001H\u0002\u001a\u0014\u0010.\u001a\u00020/*\u000200H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u001a \u00102\u001a\u00020\u0003*\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u00103\u001a\u000204\u001a\u0014\u00105\u001a\u00020\u001f*\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u00106\u001a\u00020\u001f*\u00020 2\u0006\u00107\u001a\u000208H\u0002\u001a\u0014\u00106\u001a\u00020\u001f*\u00020 2\u0006\u00107\u001a\u00020\u001bH\u0002\u001al\u00109\u001a\u00020\u001f*\u00020 2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00012\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u001a%\u0010=\u001a\u00020\u001f*\u00020 2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001a\u001e\u0010=\u001a\u00020\u001f*\u00020 2\u0006\u0010?\u001a\u00020@2\b\b\u0002\u0010A\u001a\u00020\u001bH\u0002\u001a\u0014\u0010B\u001a\u00020\u001f*\u00020 2\u0006\u00107\u001a\u000200H\u0002\u001a\u0014\u0010C\u001a\u00020\u001f*\u00020 2\u0006\u0010D\u001a\u00020;H\u0002\u001a\u0014\u0010E\u001a\u00020\u001f*\u00020 2\u0006\u00107\u001a\u00020\u001bH\u0002\u001a\u0014\u0010F\u001a\u00020\u001f*\u00020 2\u0006\u0010G\u001a\u00020\u001bH\u0002\u001a\f\u0010H\u001a\u00020\u001f*\u00020 H\u0002\u001a\u0014\u0010I\u001a\u00020\u001f*\u00020 2\u0006\u0010J\u001a\u00020KH\u0002\u001a\u0014\u0010I\u001a\u00020\u001f*\u00020 2\u0006\u0010J\u001a\u00020LH\u0002\u001a%\u0010M\u001a\u00020\u001f*\u00020 2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001a%\u0010N\u001a\u00020\u001f*\u00020 2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001a%\u0010O\u001a\u00020\u001f*\u00020 2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001a$\u0010P\u001a\u00020\u001f*\u00020 2\u0006\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010S\u001a\u000200H\u0002\u001a\u0014\u0010T\u001a\u00020\u001f*\u00020 2\u0006\u0010D\u001a\u00020;H\u0002\u001a\u001e\u0010U\u001a\u00020\u001f*\u00020 2\u0006\u0010V\u001a\u00020\u000f2\b\b\u0002\u0010W\u001a\u00020\u001bH\u0002\u001a\u0016\u0010X\u001a\u00020\u001f*\u00020 2\b\b\u0002\u0010Y\u001a\u00020\u001bH\u0002\u001a\u0014\u0010Z\u001a\u00020\u001f*\u00020 2\u0006\u0010[\u001a\u00020\tH\u0002\u001a-\u0010\\\u001a\u00020\u001f*\u00020 2\u0006\u0010\u001c\u001a\u00020\u001b2\u0017\u0010]\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001f0%\u00a2\u0006\u0002\b&H\u0002\u001ab\u0010^\u001a\u00020\u001f*\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010_\u001a\u00020`2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010a\u001a\u00020\u001f*\u00020 2\u0006\u0010\u001c\u001a\u00020K2\u0006\u00107\u001a\u00020\u000fH\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006b"}, d2={"trustManagers", "", "Ljavax/net/ssl/TrustManager;", "Ljava/security/KeyStore;", "getTrustManagers", "(Ljava/security/KeyStore;)Ljava/util/List;", "certificate", "Ljava/security/cert/Certificate;", "subject", "Lio/ktor/network/tls/certificates/Counterparty;", "issuer", "keyPair", "Ljava/security/KeyPair;", "signerKeyPair", "algorithm", "", "daysValid", "", "keyType", "Lio/ktor/network/tls/certificates/KeyType;", "generateCertificate", "file", "Ljava/io/File;", "keyAlias", "keyPassword", "jksPassword", "keySizeInBits", "", "id", "commonName", "caExtension", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "clientAuth", "derLength", "extKeyUsage", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "caKeyAlias", "caPassword", "serverAuth", "subjectAlternativeNames", "domains", "ipAddresses", "Ljava/net/InetAddress;", "toUByte", "Lkotlin/UByte;", "", "(Z)B", "trustStore", "password", "", "writeAlgorithmIdentifier", "writeAsnInt", "value", "Ljava/math/BigInteger;", "writeCertificate", "from", "Ljava/util/Date;", "to", "writeDerBitString", "block", "array", "", "unused", "writeDerBoolean", "writeDerGeneralizedTime", "date", "writeDerInt", "writeDerLength", "length", "writeDerNull", "writeDerObjectIdentifier", "identifier", "Lio/ktor/network/tls/OID;", "", "writeDerOctetString", "writeDerSequence", "writeDerSet", "writeDerType", "kind", "typeIdentifier", "simpleType", "writeDerUTCTime", "writeDerUTF8String", "s", "type", "writeVersion", "v", "writeX509Counterparty", "counterparty", "writeX509Extension", "builder", "writeX509Info", "publicKey", "Ljava/security/PublicKey;", "writeX509NamePart", "ktor-network-tls-certificates"})
public final class CertificatesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeyStore generateCertificate(@Nullable File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)jksPassword, (String)"jksPassword");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore keyStore2 = keyStore;
        keyStore2.load(null, null);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm((String)algorithm));
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        keyPairGenerator2.initialize(keySizeInBits);
        KeyPair keyPair = keyPairGenerator2.genKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        KeyPair keyPair2 = keyPair;
        Counterparty id = CertificatesKt.id(keyType == KeyType.CA ? "localhostCA" : "localhost");
        Certificate cert = CertificatesKt.certificate$default(id, id, keyPair2, keyPair2, algorithm, 0L, keyType, 32, null);
        keyStore2.setCertificateEntry(keyAlias + "Cert", cert);
        Key key = keyPair2.getPrivate();
        char[] cArray = keyPassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        Certificate[] certificateArray = new Certificate[]{cert};
        keyStore2.setKeyEntry(keyAlias, key, cArray, certificateArray);
        File file2 = file;
        if (file2 != null && (file2 = file2.getParentFile()) != null) {
            file2.mkdirs();
        }
        if (file != null) {
            Closeable $this$use$iv = new FileOutputStream(file);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileOutputStream it = (FileOutputStream)$this$use$iv;
                boolean bl = false;
                OutputStream outputStream = it;
                char[] cArray2 = jksPassword.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
                keyStore2.store(outputStream, cArray2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable first$iv) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv, (Throwable)second$iv);
                    }
                    throw first$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        return keyStore2;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(File file, String string, String string2, String string3, String string4, int n, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(file, string, string2, string3, string4, n, keyType);
    }

    private static final Counterparty id(String commonName) {
        return new Counterparty("RU", "JetBrains", "Kotlin", commonName);
    }

    private static final Certificate certificate(Counterparty subject, Counterparty issuer, KeyPair keyPair, KeyPair signerKeyPair, String algorithm, long daysValid, KeyType keyType) {
        ByteReadPacket byteReadPacket;
        Date from = new Date();
        Date to = Date.from(LocalDateTime.now().plusDays(daysValid).atZone(ZoneId.systemDefault()).toInstant());
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$certificate_u24lambda_u2d1 = builder$iv;
            boolean bl = false;
            Object object = new String[]{"127.0.0.1", "localhost"};
            List list = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.listOf((Object)Inet4Address.getByName("127.0.0.1"));
            Intrinsics.checkNotNullExpressionValue((Object)to, (String)"to");
            CertificatesKt.writeCertificate($this$certificate_u24lambda_u2d1, issuer, subject, keyPair, algorithm, from, to, list, (List<? extends InetAddress>)object, signerKeyPair, keyType);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        byte[] certificateBytes = io.ktor.utils.io.core.StringsKt.readBytes$default((ByteReadPacket)byteReadPacket, (int)0, (int)1, null);
        Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateBytes));
        cert.verify(signerKeyPair.getPublic());
        Intrinsics.checkNotNullExpressionValue((Object)cert, (String)"cert");
        return cert;
    }

    static /* synthetic */ Certificate certificate$default(Counterparty counterparty, Counterparty counterparty2, KeyPair keyPair, KeyPair keyPair2, String string, long l, KeyType keyType, int n, Object object) {
        if ((n & 0x20) != 0) {
            l = 3L;
        }
        if ((n & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.certificate(counterparty, counterparty2, keyPair, keyPair2, string, l, keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeyStore generateCertificate(@NotNull KeyStore $this$generateCertificate, @Nullable File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull String caKeyAlias, @NotNull String caPassword, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)$this$generateCertificate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)jksPassword, (String)"jksPassword");
        Intrinsics.checkNotNullParameter((Object)caKeyAlias, (String)"caKeyAlias");
        Intrinsics.checkNotNullParameter((Object)caPassword, (String)"caPassword");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        Certificate caCert = $this$generateCertificate.getCertificate(caKeyAlias);
        PublicKey publicKey = caCert.getPublicKey();
        char[] cArray = caPassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        Key key = $this$generateCertificate.getKey(caKeyAlias, cArray);
        if (key == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        KeyPair ca = new KeyPair(publicKey, (PrivateKey)key);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore keyStore2 = keyStore;
        keyStore2.load(null, null);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm((String)algorithm));
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        keyPairGenerator2.initialize(keySizeInBits);
        KeyPair keyPair = keyPairGenerator2.genKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        KeyPair certKeyPair = keyPair;
        Certificate[] certificateArray = CertificatesKt.id("localhostCA");
        Certificate cert = CertificatesKt.certificate$default(CertificatesKt.id("localhost"), (Counterparty)certificateArray, certKeyPair, ca, algorithm, 0L, keyType, 32, null);
        keyStore2.setCertificateEntry(keyAlias, cert);
        Key key2 = certKeyPair.getPrivate();
        char[] cArray2 = keyPassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        certificateArray = new Certificate[]{cert, caCert};
        keyStore2.setKeyEntry(keyAlias, key2, cArray2, certificateArray);
        File file2 = file;
        if (file2 != null && (file2 = file2.getParentFile()) != null) {
            file2.mkdirs();
        }
        if (file != null) {
            Closeable $this$use$iv = new FileOutputStream(file);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileOutputStream it = (FileOutputStream)$this$use$iv;
                boolean bl = false;
                OutputStream outputStream = it;
                char[] cArray3 = jksPassword.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"this as java.lang.String).toCharArray()");
                keyStore2.store(outputStream, cArray3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable first$iv) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv, (Throwable)second$iv);
                    }
                    throw first$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        return keyStore2;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(KeyStore keyStore, File file, String string, String string2, String string3, String string4, int n, String string5, String string6, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            string5 = "mykey";
        }
        if ((n2 & 0x80) != 0) {
            string6 = "changeit";
        }
        if ((n2 & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(keyStore, file, string, string2, string3, string4, n, string5, string6, keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore trustStore(@NotNull KeyStore $this$trustStore, @Nullable File file, @NotNull char[] password) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$trustStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore trustStore = keyStore;
        trustStore.load(null, null);
        Enumeration<String> enumeration = $this$trustStore.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases()");
        ArrayList<String> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
        Iterable iterable = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Certificate cert;
            String alias = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$trustStore.getCertificate(alias), (String)"getCertificate(alias)");
            trustStore.setCertificateEntry(alias, cert);
        }
        File file2 = file;
        if (file2 != null && (file2 = file2.getParentFile()) != null) {
            file2.mkdirs();
        }
        if (file != null) {
            Closeable $this$use$iv = new FileOutputStream(file);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileOutputStream it = (FileOutputStream)$this$use$iv;
                boolean bl = false;
                trustStore.store(it, password);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable first$iv) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        CloseableJVMKt.addSuppressedInternal((Throwable)first$iv, (Throwable)second$iv);
                    }
                    throw first$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        return trustStore;
    }

    public static /* synthetic */ KeyStore trustStore$default(KeyStore keyStore, File file, char[] cArray, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            char[] cArray2 = "changeit".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            cArray = cArray2;
        }
        return CertificatesKt.trustStore(keyStore, file, cArray);
    }

    @NotNull
    public static final List<TrustManager> getTrustManagers(@NotNull KeyStore $this$trustManagers) {
        TrustManagerFactory trustManagerFactory;
        Intrinsics.checkNotNullParameter((Object)$this$trustManagers, (String)"<this>");
        TrustManagerFactory $this$_get_trustManagers__u24lambda_u2d5 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        $this$_get_trustManagers__u24lambda_u2d5.init($this$trustManagers);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getInstance(TrustManager\u2026Managers) }.trustManagers");
        return ArraysKt.toList((Object[])trustManagerArray);
    }

    public static final void writeX509Info(@NotNull BytePacketBuilder $this$writeX509Info, @NotNull String algorithm, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull PublicKey publicKey, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)$this$writeX509Info, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        Intrinsics.checkNotNullParameter(ipAddresses, (String)"ipAddresses");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        BigInteger version = new BigInteger(64, new SecureRandom());
        CertificatesKt.writeDerSequence($this$writeX509Info, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(version, algorithm, issuer, subject, publicKey, from, to, keyType, domains, ipAddresses){
            final /* synthetic */ BigInteger $version;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ Counterparty $issuer;
            final /* synthetic */ Counterparty $subject;
            final /* synthetic */ PublicKey $publicKey;
            final /* synthetic */ Date $from;
            final /* synthetic */ Date $to;
            final /* synthetic */ KeyType $keyType;
            final /* synthetic */ List<String> $domains;
            final /* synthetic */ List<InetAddress> $ipAddresses;
            {
                this.$version = $version;
                this.$algorithm = $algorithm;
                this.$issuer = $issuer;
                this.$subject = $subject;
                this.$publicKey = $publicKey;
                this.$from = $from;
                this.$to = $to;
                this.$keyType = $keyType;
                this.$domains = $domains;
                this.$ipAddresses = $ipAddresses;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                ByteReadPacket byteReadPacket;
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                CertificatesKt.access$writeVersion($this$writeDerSequence, 2);
                CertificatesKt.access$writeAsnInt($this$writeDerSequence, this.$version);
                CertificatesKt.access$writeAlgorithmIdentifier($this$writeDerSequence, this.$algorithm);
                CertificatesKt.access$writeX509Counterparty($this$writeDerSequence, this.$issuer);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, (Function1)new Function1<BytePacketBuilder, Unit>(this.$from, this.$to){
                    final /* synthetic */ Date $from;
                    final /* synthetic */ Date $to;
                    {
                        this.$from = $from;
                        this.$to = $to;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                        CertificatesKt.access$writeDerUTCTime($this$writeDerSequence, this.$from);
                        CertificatesKt.access$writeDerGeneralizedTime($this$writeDerSequence, this.$to);
                    }
                });
                CertificatesKt.access$writeX509Counterparty($this$writeDerSequence, this.$subject);
                Output output = (Output)$this$writeDerSequence;
                byte[] byArray = this.$publicKey.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
                OutputKt.writeFully$default((Output)output, (byte[])byArray, (int)0, (int)0, (int)6, null);
                $this$writeDerSequence.writeByte((byte)-93);
                KeyType keyType = this.$keyType;
                List<String> list = this.$domains;
                List<InetAddress> list2 = this.$ipAddresses;
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    BytePacketBuilder $this$invoke_u24lambda_u2d0 = builder$iv;
                    boolean bl = false;
                    CertificatesKt.access$writeDerSequence($this$invoke_u24lambda_u2d0, (Function1)new Function1<BytePacketBuilder, Unit>(keyType, list, list2){
                        final /* synthetic */ KeyType $keyType;
                        final /* synthetic */ List<String> $domains;
                        final /* synthetic */ List<InetAddress> $ipAddresses;
                        {
                            this.$keyType = $keyType;
                            this.$domains = $domains;
                            this.$ipAddresses = $ipAddresses;
                            super(1);
                        }

                        public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                            Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                            switch (writeX509Info.extensions.1.WhenMappings.$EnumSwitchMapping$0[this.$keyType.ordinal()]) {
                                case 1: {
                                    CertificatesKt.access$caExtension($this$writeDerSequence);
                                    break;
                                }
                                case 2: {
                                    CertificatesKt.access$extKeyUsage($this$writeDerSequence, writeX509Info.extensions.1.1.INSTANCE);
                                    CertificatesKt.access$subjectAlternativeNames($this$writeDerSequence, this.$domains, this.$ipAddresses);
                                    break;
                                }
                                case 3: {
                                    CertificatesKt.access$extKeyUsage($this$writeDerSequence, writeX509Info.extensions.1.2.INSTANCE);
                                }
                            }
                        }
                    });
                    byteReadPacket = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                ByteReadPacket extensions2 = byteReadPacket;
                CertificatesKt.access$writeDerLength($this$writeDerSequence, (int)extensions2.getRemaining());
                $this$writeDerSequence.writePacket(extensions2);
            }
        }));
    }

    public static /* synthetic */ void writeX509Info$default(BytePacketBuilder bytePacketBuilder, String string, Counterparty counterparty, Counterparty counterparty2, PublicKey publicKey, Date date, Date date2, List list, List list2, KeyType keyType, int n, Object object) {
        if ((n & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeX509Info(bytePacketBuilder, string, counterparty, counterparty2, publicKey, date, date2, list, list2, keyType);
    }

    private static final void extKeyUsage(BytePacketBuilder $this$extKeyUsage, Function1<? super BytePacketBuilder, Unit> content) {
        CertificatesKt.writeDerSequence($this$extKeyUsage, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(content){
            final /* synthetic */ Function1<BytePacketBuilder, Unit> $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getExtKeyUsage());
                CertificatesKt.access$writeDerOctetString($this$writeDerSequence, (Function1)new Function1<BytePacketBuilder, Unit>(this.$content){
                    final /* synthetic */ Function1<BytePacketBuilder, Unit> $content;
                    {
                        this.$content = $content;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerOctetString) {
                        Intrinsics.checkNotNullParameter((Object)$this$writeDerOctetString, (String)"$this$writeDerOctetString");
                        this.$content.invoke((Object)$this$writeDerOctetString);
                    }
                });
            }
        }));
    }

    private static final void clientAuth(BytePacketBuilder $this$clientAuth) {
        CertificatesKt.writeDerSequence($this$clientAuth, (Function1<? super BytePacketBuilder, Unit>)((Function1)clientAuth.1.INSTANCE));
    }

    private static final void serverAuth(BytePacketBuilder $this$serverAuth) {
        CertificatesKt.writeDerSequence($this$serverAuth, (Function1<? super BytePacketBuilder, Unit>)((Function1)serverAuth.1.INSTANCE));
    }

    private static final void subjectAlternativeNames(BytePacketBuilder $this$subjectAlternativeNames, List<String> domains, List<? extends InetAddress> ipAddresses) {
        CertificatesKt.writeDerSequence($this$subjectAlternativeNames, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(domains, ipAddresses){
            final /* synthetic */ List<String> $domains;
            final /* synthetic */ List<InetAddress> $ipAddresses;
            {
                this.$domains = $domains;
                this.$ipAddresses = $ipAddresses;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getSubjectAltName());
                CertificatesKt.access$writeDerOctetString($this$writeDerSequence, (Function1)new Function1<BytePacketBuilder, Unit>(this.$domains, this.$ipAddresses){
                    final /* synthetic */ List<String> $domains;
                    final /* synthetic */ List<InetAddress> $ipAddresses;
                    {
                        this.$domains = $domains;
                        this.$ipAddresses = $ipAddresses;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerOctetString) {
                        Intrinsics.checkNotNullParameter((Object)$this$writeDerOctetString, (String)"$this$writeDerOctetString");
                        CertificatesKt.access$writeDerSequence($this$writeDerOctetString, (Function1)new Function1<BytePacketBuilder, Unit>(this.$domains, this.$ipAddresses){
                            final /* synthetic */ List<String> $domains;
                            final /* synthetic */ List<InetAddress> $ipAddresses;
                            {
                                this.$domains = $domains;
                                this.$ipAddresses = $ipAddresses;
                                super(1);
                            }

                            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                                for (String domain : this.$domains) {
                                    CertificatesKt.access$writeX509Extension($this$writeDerSequence, 2, (Function1)new Function1<BytePacketBuilder, Unit>(domain){
                                        final /* synthetic */ String $domain;
                                        {
                                            this.$domain = $domain;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                            byte[] byArray;
                                            Intrinsics.checkNotNullParameter((Object)$this$writeX509Extension, (String)"$this$writeX509Extension");
                                            Output output = (Output)$this$writeX509Extension;
                                            String $this$toByteArray_u24default$iv = this.$domain;
                                            Charset charset$iv = Charsets.UTF_8;
                                            boolean $i$f$toByteArray = false;
                                            if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
                                                byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
                                            } else {
                                                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                                                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                                                byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
                                            }
                                            OutputKt.writeFully$default((Output)output, (byte[])byArray, (int)0, (int)0, (int)6, null);
                                        }
                                    });
                                }
                                for (InetAddress ip : this.$ipAddresses) {
                                    CertificatesKt.access$writeX509Extension($this$writeDerSequence, 7, (Function1)new Function1<BytePacketBuilder, Unit>(ip){
                                        final /* synthetic */ InetAddress $ip;
                                        {
                                            this.$ip = $ip;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                            Intrinsics.checkNotNullParameter((Object)$this$writeX509Extension, (String)"$this$writeX509Extension");
                                            Output output = (Output)$this$writeX509Extension;
                                            byte[] byArray = this.$ip.getAddress();
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ip.address");
                                            OutputKt.writeFully$default((Output)output, (byte[])byArray, (int)0, (int)0, (int)6, null);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }));
    }

    private static final void caExtension(BytePacketBuilder $this$caExtension) {
        CertificatesKt.writeDerSequence($this$caExtension, (Function1<? super BytePacketBuilder, Unit>)((Function1)caExtension.1.INSTANCE));
    }

    private static final void writeAlgorithmIdentifier(BytePacketBuilder $this$writeAlgorithmIdentifier, String algorithm) {
        CertificatesKt.writeDerSequence($this$writeAlgorithmIdentifier, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(algorithm){
            final /* synthetic */ String $algorithm;
            {
                this.$algorithm = $algorithm;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                OID oid = OID.Companion.fromAlgorithm(this.$algorithm);
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, oid);
                CertificatesKt.access$writeDerNull($this$writeDerSequence);
            }
        }));
    }

    private static final void writeX509Extension(BytePacketBuilder $this$writeX509Extension, int id, Function1<? super BytePacketBuilder, Unit> builder) {
        ByteReadPacket byteReadPacket;
        $this$writeX509Extension.writeByte((byte)(0x80 | id));
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeX509Extension_u24lambda_u2d6 = builder$iv;
            boolean bl = false;
            builder.invoke((Object)$this$writeX509Extension_u24lambda_u2d6);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeX509Extension, (int)packet.getRemaining());
        $this$writeX509Extension.writePacket(packet);
    }

    private static final void writeX509NamePart(BytePacketBuilder $this$writeX509NamePart, OID id, String value) {
        CertificatesKt.writeDerSet($this$writeX509NamePart, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(id, value){
            final /* synthetic */ OID $id;
            final /* synthetic */ String $value;
            {
                this.$id = $id;
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSet) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSet, (String)"$this$writeDerSet");
                CertificatesKt.access$writeDerSequence($this$writeDerSet, (Function1)new Function1<BytePacketBuilder, Unit>(this.$id, this.$value){
                    final /* synthetic */ OID $id;
                    final /* synthetic */ String $value;
                    {
                        this.$id = $id;
                        this.$value = $value;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                        CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, this.$id);
                        CertificatesKt.writeDerUTF8String$default($this$writeDerSequence, this.$value, 0, 2, null);
                    }
                });
            }
        }));
    }

    private static final void writeX509Counterparty(BytePacketBuilder $this$writeX509Counterparty, Counterparty counterparty) {
        CertificatesKt.writeDerSequence($this$writeX509Counterparty, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(counterparty){
            final /* synthetic */ Counterparty $counterparty;
            {
                this.$counterparty = $counterparty;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                if (((CharSequence)this.$counterparty.getCountry()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getCountryName(), this.$counterparty.getCountry());
                }
                if (((CharSequence)this.$counterparty.getOrganization()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getOrganizationName(), this.$counterparty.getOrganization());
                }
                if (((CharSequence)this.$counterparty.getOrganizationUnit()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getOrganizationalUnitName(), this.$counterparty.getOrganizationUnit());
                }
                if (((CharSequence)this.$counterparty.getCommonName()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getCommonName(), this.$counterparty.getCommonName());
                }
            }
        }));
    }

    public static final void writeCertificate(@NotNull BytePacketBuilder $this$writeCertificate, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull KeyPair keyPair, @NotNull String algorithm, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses, @NotNull KeyPair signerKeyPair, @NotNull KeyType keyType) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$writeCertificate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        Intrinsics.checkNotNullParameter(ipAddresses, (String)"ipAddresses");
        Intrinsics.checkNotNullParameter((Object)signerKeyPair, (String)"signerKeyPair");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        if (!to.after(from)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeCertificate_u24lambda_u2d7 = builder$iv;
            boolean bl = false;
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.public");
            CertificatesKt.writeX509Info($this$writeCertificate_u24lambda_u2d7, algorithm, issuer, subject, publicKey, from, to, domains, ipAddresses, keyType);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket certInfo = byteReadPacket;
        byte[] certInfoBytes = io.ktor.utils.io.core.StringsKt.readBytes$default((ByteReadPacket)certInfo, (int)0, (int)1, null);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(signerKeyPair.getPrivate());
        signature.update(certInfoBytes);
        byte[] signed = signature.sign();
        CertificatesKt.writeDerSequence($this$writeCertificate, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(certInfoBytes, signed, algorithm){
            final /* synthetic */ byte[] $certInfoBytes;
            final /* synthetic */ byte[] $signed;
            final /* synthetic */ String $algorithm;
            {
                this.$certInfoBytes = $certInfoBytes;
                this.$signed = $signed;
                this.$algorithm = $algorithm;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                OutputKt.writeFully$default((Output)((Output)$this$writeDerSequence), (byte[])this.$certInfoBytes, (int)0, (int)0, (int)6, null);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, (Function1)new Function1<BytePacketBuilder, Unit>(this.$algorithm){
                    final /* synthetic */ String $algorithm;
                    {
                        this.$algorithm = $algorithm;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
                        CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.fromAlgorithm(this.$algorithm));
                        CertificatesKt.access$writeDerNull($this$writeDerSequence);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)this.$signed, (String)"signed");
                CertificatesKt.writeDerBitString$default($this$writeDerSequence, this.$signed, 0, 2, null);
            }
        }));
    }

    public static /* synthetic */ void writeCertificate$default(BytePacketBuilder bytePacketBuilder, Counterparty counterparty, Counterparty counterparty2, KeyPair keyPair, String string, Date date, Date date2, List list, List list2, KeyPair keyPair2, KeyType keyType, int n, Object object) {
        if ((n & 0x100) != 0) {
            keyPair2 = keyPair;
        }
        if ((n & 0x200) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeCertificate(bytePacketBuilder, counterparty, counterparty2, keyPair, string, date, date2, list, list2, keyPair2, keyType);
    }

    private static final void writeVersion(BytePacketBuilder $this$writeVersion, int v) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeVersion, 2, 0, false);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeVersion_u24lambda_u2d8 = builder$iv;
            boolean bl = false;
            CertificatesKt.writeAsnInt($this$writeVersion_u24lambda_u2d8, v);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeVersion, (int)encoded.getRemaining());
        $this$writeVersion.writePacket(encoded);
    }

    static /* synthetic */ void writeVersion$default(BytePacketBuilder bytePacketBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        CertificatesKt.writeVersion(bytePacketBuilder, n);
    }

    private static final void writeDerOctetString(BytePacketBuilder $this$writeDerOctetString, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerOctetString_u24lambda_u2d9 = builder$iv;
            boolean bl = false;
            block.invoke((Object)$this$writeDerOctetString_u24lambda_u2d9);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerOctetString, 0, 4, true);
        CertificatesKt.writeDerLength($this$writeDerOctetString, (int)sub.getRemaining());
        $this$writeDerOctetString.writePacket(sub);
    }

    private static final void writeDerBitString(BytePacketBuilder $this$writeDerBitString, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerBitString_u24lambda_u2d10 = builder$iv;
            boolean bl = false;
            block.invoke((Object)$this$writeDerBitString_u24lambda_u2d10);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, (int)sub.getRemaining() + 1);
        $this$writeDerBitString.writeByte((byte)0);
        $this$writeDerBitString.writePacket(sub);
    }

    private static final void writeDerBitString(BytePacketBuilder $this$writeDerBitString, byte[] array, int unused) {
        if (!(0 <= unused ? unused < 8 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, array.length + 1);
        $this$writeDerBitString.writeByte((byte)unused);
        OutputKt.writeFully$default((Output)((Output)$this$writeDerBitString), (byte[])array, (int)0, (int)0, (int)6, null);
    }

    static /* synthetic */ void writeDerBitString$default(BytePacketBuilder bytePacketBuilder, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        CertificatesKt.writeDerBitString(bytePacketBuilder, byArray, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerUTCTime(BytePacketBuilder $this$writeDerUTCTime, Date date) {
        void $this$writeDerUTCTime_u24lambda_u2d11;
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $this$writeDerUTCTime;
        boolean bl = false;
        $this$writeDerUTCTime_u24lambda_u2d11.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = simpleDateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(\"yyMMdd\u2026\")\n        }.format(date)");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 23);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerGeneralizedTime(BytePacketBuilder $this$writeDerGeneralizedTime, Date date) {
        void $this$writeDerGeneralizedTime_u24lambda_u2d12;
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $this$writeDerGeneralizedTime;
        boolean bl = false;
        $this$writeDerGeneralizedTime_u24lambda_u2d12.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = simpleDateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(\"yyyyMM\u2026           date\n        )");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 24);
    }

    private static final void writeDerUTF8String(BytePacketBuilder $this$writeDerUTF8String, String s, int type) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerUTF8String_u24lambda_u2d13 = builder$iv;
            boolean bl = false;
            io.ktor.utils.io.core.StringsKt.writeText$default((Output)((Output)$this$writeDerUTF8String_u24lambda_u2d13), (CharSequence)s, (int)0, (int)0, null, (int)14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerUTF8String, 0, type, true);
        CertificatesKt.writeDerLength($this$writeDerUTF8String, (int)sub.getRemaining());
        $this$writeDerUTF8String.writePacket(sub);
    }

    static /* synthetic */ void writeDerUTF8String$default(BytePacketBuilder bytePacketBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, n);
    }

    private static final void writeDerNull(BytePacketBuilder $this$writeDerNull) {
        OutputPrimitivesKt.writeShort((Output)((Output)$this$writeDerNull), (short)1280);
    }

    private static final void writeDerSequence(BytePacketBuilder $this$writeDerSequence, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerSequence_u24lambda_u2d14 = builder$iv;
            boolean bl = false;
            block.invoke((Object)$this$writeDerSequence_u24lambda_u2d14);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerSequence, 0, 16, false);
        CertificatesKt.writeDerLength($this$writeDerSequence, (int)sub.getRemaining());
        $this$writeDerSequence.writePacket(sub);
    }

    private static final void writeDerSet(BytePacketBuilder $this$writeDerSet, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerSet_u24lambda_u2d15 = builder$iv;
            boolean bl = false;
            block.invoke((Object)$this$writeDerSet_u24lambda_u2d15);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerSet, 0, 17, false);
        CertificatesKt.writeDerLength($this$writeDerSet, (int)sub.getRemaining());
        $this$writeDerSet.writePacket(sub);
    }

    private static final void writeDerObjectIdentifier(BytePacketBuilder $this$writeDerObjectIdentifier, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($this$writeDerObjectIdentifier, identifier.getAsArray());
    }

    /*
     * Unable to fully structure code
     */
    private static final void writeDerObjectIdentifier(BytePacketBuilder $this$writeDerObjectIdentifier, int[] identifier) {
        if (!(identifier.length >= 2)) {
            var3_2 = "Failed requirement.";
            throw new IllegalArgumentException(var3_2.toString());
        }
        var2_6 = identifier[0];
        if (!(0 <= var2_6 ? var2_6 < 3 : false)) {
            var3_3 = "Failed requirement.";
            throw new IllegalArgumentException(var3_3.toString());
        }
        if (identifier[0] == 2) ** GOTO lbl-1000
        var2_6 = identifier[1];
        v0 = 0 <= var2_6 ? var2_6 < 40 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            var3_4 = "Failed requirement.";
            throw new IllegalArgumentException(var3_4.toString());
        }
        $i$f$buildPacket = false;
        builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            $this$writeDerObjectIdentifier_u24lambda_u2d16 = builder$iv;
            $i$a$-buildPacket-CertificatesKt$writeDerObjectIdentifier$sub$1 = false;
            CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2d16, identifier[0] * 40 + identifier[1]);
            i = 2;
            var8_13 = ArraysKt.getLastIndex((int[])identifier);
            if (i <= var8_13) {
                while (true) {
                    CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2d16, identifier[i]);
                    if (i == var8_13) break;
                    ++i;
                }
            }
            v2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        sub = v2;
        CertificatesKt.writeDerType($this$writeDerObjectIdentifier, 0, 6, true);
        CertificatesKt.writeDerLength($this$writeDerObjectIdentifier, (int)sub.getRemaining());
        $this$writeDerObjectIdentifier.writePacket(sub);
    }

    private static final void writeAsnInt(BytePacketBuilder $this$writeAsnInt, BigInteger value) {
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        byte[] encoded = value.toByteArray();
        CertificatesKt.writeDerLength($this$writeAsnInt, encoded.length);
        Output output = (Output)$this$writeAsnInt;
        Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
        OutputKt.writeFully$default((Output)output, (byte[])encoded, (int)0, (int)0, (int)6, null);
    }

    private static final void writeAsnInt(BytePacketBuilder $this$writeAsnInt, int value) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeAsnInt_u24lambda_u2d17 = builder$iv;
            boolean bl = false;
            boolean skip = true;
            for (int idx = 0; idx < 4; ++idx) {
                int part = value >>> (4 - idx - 1) * 8 & 0xFF;
                if (part == 0 && skip) continue;
                skip = false;
                $this$writeAsnInt_u24lambda_u2d17.writeByte((byte)part);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeAsnInt, (int)encoded.getRemaining());
        $this$writeAsnInt.writePacket(encoded);
    }

    private static final void writeDerLength(BytePacketBuilder $this$writeDerLength, int length) {
        if (!(length >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length <= 127) {
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 255) {
            $this$writeDerLength.writeByte((byte)-127);
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 65535) {
            $this$writeDerLength.writeByte((byte)-126);
            $this$writeDerLength.writeByte((byte)(length >>> 8));
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 0xFFFFFF) {
            $this$writeDerLength.writeByte((byte)-125);
            $this$writeDerLength.writeByte((byte)(length >>> 16));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        } else {
            $this$writeDerLength.writeByte((byte)-124);
            $this$writeDerLength.writeByte((byte)(length >>> 24));
            $this$writeDerLength.writeByte((byte)(length >>> 16 & 0xFF));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        }
    }

    private static final void writeDerType(BytePacketBuilder $this$writeDerType, int kind, int typeIdentifier, boolean simpleType) {
        if (!(0 <= kind ? kind < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(typeIdentifier >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl = 0 <= typeIdentifier ? typeIdentifier < 31 : false;
        if (bl) {
            int singleByte = kind << 6 | typeIdentifier | (simpleType ? 0 : 32);
            byte byteValue = (byte)singleByte;
            $this$writeDerType.writeByte(byteValue);
        } else {
            int firstByte = kind << 6 | 0x1F | (simpleType ? 0 : 32);
            $this$writeDerType.writeByte((byte)firstByte);
            CertificatesKt.writeDerInt($this$writeDerType, typeIdentifier);
        }
    }

    private static final int derLength(int $this$derLength) {
        if (!($this$derLength >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$derLength == 0) {
            return 0;
        }
        int mask = 127;
        int byteCount = 1;
        while (($this$derLength & mask) != $this$derLength) {
            mask |= mask << 7;
            ++byteCount;
        }
        return byteCount;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerBoolean(BytePacketBuilder $this$writeDerBoolean, boolean value) {
        void $this$writeUByte_u2dEK_u2d6454$iv;
        CertificatesKt.writeDerType($this$writeDerBoolean, 0, 1, true);
        CertificatesKt.writeDerLength($this$writeDerBoolean, 1);
        Output output = (Output)$this$writeDerBoolean;
        byte v$iv = CertificatesKt.toUByte(value);
        boolean bl = false;
        $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
    }

    private static final byte toUByte(boolean $this$toUByte) {
        return $this$toUByte ? UByte.constructor-impl((byte)((byte)255)) : UByte.constructor-impl((byte)((byte)0));
    }

    private static final void writeDerInt(BytePacketBuilder $this$writeDerInt, int value) {
        if (!(value >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int byteCount = CertificatesKt.derLength(value);
        for (int i = 0; i < byteCount; ++i) {
            int idx = i;
            boolean bl = false;
            int part = value >> (byteCount - idx - 1) * 7 & 0x7F;
            if (idx == byteCount - 1) {
                $this$writeDerInt.writeByte((byte)part);
                continue;
            }
            $this$writeDerInt.writeByte((byte)(part | 0x80));
        }
    }

    public static final /* synthetic */ void access$writeVersion(BytePacketBuilder $receiver, int v) {
        CertificatesKt.writeVersion($receiver, v);
    }

    public static final /* synthetic */ void access$writeAsnInt(BytePacketBuilder $receiver, BigInteger value) {
        CertificatesKt.writeAsnInt($receiver, value);
    }

    public static final /* synthetic */ void access$writeAlgorithmIdentifier(BytePacketBuilder $receiver, String algorithm) {
        CertificatesKt.writeAlgorithmIdentifier($receiver, algorithm);
    }

    public static final /* synthetic */ void access$writeX509Counterparty(BytePacketBuilder $receiver, Counterparty counterparty) {
        CertificatesKt.writeX509Counterparty($receiver, counterparty);
    }

    public static final /* synthetic */ void access$writeDerSequence(BytePacketBuilder $receiver, Function1 block) {
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)block);
    }

    public static final /* synthetic */ void access$writeDerUTCTime(BytePacketBuilder $receiver, Date date) {
        CertificatesKt.writeDerUTCTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerGeneralizedTime(BytePacketBuilder $receiver, Date date) {
        CertificatesKt.writeDerGeneralizedTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerLength(BytePacketBuilder $receiver, int length) {
        CertificatesKt.writeDerLength($receiver, length);
    }

    public static final /* synthetic */ void access$caExtension(BytePacketBuilder $receiver) {
        CertificatesKt.caExtension($receiver);
    }

    public static final /* synthetic */ void access$extKeyUsage(BytePacketBuilder $receiver, Function1 content) {
        CertificatesKt.extKeyUsage($receiver, (Function1<? super BytePacketBuilder, Unit>)content);
    }

    public static final /* synthetic */ void access$serverAuth(BytePacketBuilder $receiver) {
        CertificatesKt.serverAuth($receiver);
    }

    public static final /* synthetic */ void access$subjectAlternativeNames(BytePacketBuilder $receiver, List domains, List ipAddresses) {
        CertificatesKt.subjectAlternativeNames($receiver, domains, ipAddresses);
    }

    public static final /* synthetic */ void access$clientAuth(BytePacketBuilder $receiver) {
        CertificatesKt.clientAuth($receiver);
    }

    public static final /* synthetic */ void access$writeDerObjectIdentifier(BytePacketBuilder $receiver, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($receiver, identifier);
    }

    public static final /* synthetic */ void access$writeDerOctetString(BytePacketBuilder $receiver, Function1 block) {
        CertificatesKt.writeDerOctetString($receiver, (Function1<? super BytePacketBuilder, Unit>)block);
    }

    public static final /* synthetic */ void access$writeX509Extension(BytePacketBuilder $receiver, int id, Function1 builder) {
        CertificatesKt.writeX509Extension($receiver, id, (Function1<? super BytePacketBuilder, Unit>)builder);
    }

    public static final /* synthetic */ void access$writeDerBoolean(BytePacketBuilder $receiver, boolean value) {
        CertificatesKt.writeDerBoolean($receiver, value);
    }

    public static final /* synthetic */ void access$writeDerNull(BytePacketBuilder $receiver) {
        CertificatesKt.writeDerNull($receiver);
    }

    public static final /* synthetic */ void access$writeX509NamePart(BytePacketBuilder $receiver, OID id, String value) {
        CertificatesKt.writeX509NamePart($receiver, id, value);
    }
}

