/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.certificates.CertificateBuilder;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.util.CharsetKt;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\b\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/ktor/network/tls/certificates/KeyStoreBuilder;", "", "()V", "certificates", "", "", "Lio/ktor/network/tls/certificates/CertificateInfo;", "build", "Ljava/security/KeyStore;", "build$ktor_network_tls_certificates", "certificate", "", "alias", "block", "Lkotlin/Function1;", "Lio/ktor/network/tls/certificates/CertificateBuilder;", "Lkotlin/ExtensionFunctionType;", "ktor-network-tls-certificates"})
public final class KeyStoreBuilder {
    @NotNull
    private final Map<String, CertificateInfo> certificates = new LinkedHashMap();

    public final void certificate(@NotNull String alias, @NotNull Function1<? super CertificateBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Map<String, CertificateInfo> map = this.certificates;
        Object object = new CertificateBuilder();
        block.invoke(object);
        object = ((CertificateBuilder)object).build$ktor_network_tls_certificates();
        map.put(alias, (CertificateInfo)object);
    }

    @NotNull
    public final KeyStore build$ktor_network_tls_certificates() {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore store = keyStore;
        store.load(null, null);
        Map<String, CertificateInfo> $this$forEach$iv = this.certificates;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, CertificateInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CertificateInfo> element$iv;
            Map.Entry<String, CertificateInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            String alias = entry.getKey();
            CertificateInfo info = entry.getValue();
            Certificate certificate = info.component1();
            KeyPair keys = info.component2();
            String password = info.component3();
            store.setCertificateEntry(alias, certificate);
            Certificate[] certificateArray = new Certificate[]{certificate};
            store.setKeyEntry(alias, keys.getPrivate(), CharsetKt.toCharArray((String)password), certificateArray);
        }
        return store;
    }
}

