/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.application.Application;
import io.ktor.application.ApplicationKt;
import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilder;
import io.ktor.response.ResponsePushBuilder;
import io.ktor.response.UseHttp2Push;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.cio.NettyRequestQueue;
import io.ktor.server.netty.cio.NettyResponsePipeline;
import io.ktor.server.netty.cio.WriterEncapsulation;
import io.ktor.server.netty.http2.NettyHttp2ApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ChannelHandler.Sharable
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00029:B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u001d\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0001\u00a2\u0006\u0002\b,J\u0011\u0010-\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030.H\u0082\u0010J\u0014\u0010/\u001a\u00020\u001c*\u0002002\u0006\u00101\u001a\u000202H\u0002J\u001c\u00103\u001a\u000204*\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0012*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006;"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "application", "Lio/ktor/application/Application;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "userCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/application/Application;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handlerJob", "Lkotlinx/coroutines/CompletableJob;", "streamKeyField", "Ljava/lang/reflect/Field;", "getStreamKeyField", "()Ljava/lang/reflect/Field;", "streamKeyField$delegate", "Lkotlin/Lazy;", "idField", "Lio/netty/handler/codec/http2/Http2FrameStream;", "getIdField", "(Lio/netty/handler/codec/http2/Http2FrameStream;)Ljava/lang/reflect/Field;", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "channelRegistered", "ctx", "exceptionCaught", "cause", "", "startHttp2", "headers", "Lio/netty/handler/codec/http2/Http2Headers;", "startHttp2PushPromise", "builder", "Lio/ktor/response/ResponsePushBuilder;", "startHttp2PushPromise$ktor_server_netty", "findIdField", "Ljava/lang/Class;", "setId", "Lio/netty/handler/codec/http2/Http2StreamChannel;", "streamId", "", "setStreamAndProperty", "", "codec", "Lio/netty/handler/codec/http2/Http2FrameCodec;", "childStream", "Lio/netty/handler/codec/http2/Http2Stream;", "Companion", "Http2ClosedChannelException", "ktor-server-netty"})
public final class NettyHttp2Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    private final CompletableJob handlerJob;
    private final Lazy streamKeyField$delegate;
    private final EnginePipeline enginePipeline;
    private final Application application;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext userCoroutineContext;
    private static final AttributeKey<NettyHttp2ApplicationCall> ApplicationCallKey;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    public void channelRead(@NotNull ChannelHandlerContext context, @Nullable Object message) {
        block7: {
            Object object;
            block8: {
                Object object2;
                block9: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        object = message;
                        if (!(object instanceof Http2HeadersFrame)) break block6;
                        Http2Headers http2Headers = ((Http2HeadersFrame)message).headers();
                        Intrinsics.checkNotNullExpressionValue((Object)http2Headers, (String)"message.headers()");
                        this.startHttp2(context, http2Headers);
                        break block7;
                    }
                    if (!(object instanceof Http2DataFrame)) break block8;
                    object2 = NettyHttp2Handler.Companion.getApplicationCall(context);
                    if (object2 == null || (object2 = object2.getRequest()) == null) break block9;
                    NettyHttp2ApplicationCall nettyHttp2ApplicationCall = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    NettyHttp2ApplicationCall $this$apply = nettyHttp2ApplicationCall;
                    boolean bl3 = false;
                    boolean eof = ((Http2DataFrame)message).isEndStream();
                    ((NettyHttp2ApplicationRequest)((Object)$this$apply)).getContentActor().offer(message);
                    if (eof) {
                        SendChannel.DefaultImpls.close$default(((NettyHttp2ApplicationRequest)((Object)$this$apply)).getContentActor(), null, (int)1, null);
                    }
                    if ((object2 = nettyHttp2ApplicationCall) != null) break block7;
                }
                object2 = ((Http2DataFrame)message).release();
                break block7;
            }
            if (object instanceof Http2ResetFrame) {
                Object object3 = NettyHttp2Handler.Companion.getApplicationCall(context);
                if (object3 != null && (object3 = object3.getRequest()) != null) {
                    NettyHttp2ApplicationCall nettyHttp2ApplicationCall = object3;
                    boolean bl = false;
                    boolean bl4 = false;
                    NettyHttp2ApplicationCall r = nettyHttp2ApplicationCall;
                    boolean bl5 = false;
                    Http2ClosedChannelException e = ((Http2ResetFrame)message).errorCode() == 0L ? null : new Http2ClosedChannelException(((Http2ResetFrame)message).errorCode());
                    ((NettyHttp2ApplicationRequest)((Object)r)).getContentActor().close((Throwable)e);
                }
            } else {
                context.fireChannelRead(message);
            }
        }
    }

    public void channelRegistered(@Nullable ChannelHandlerContext ctx) {
        block0: {
            super.channelRegistered(ctx);
            ChannelHandlerContext channelHandlerContext = ctx;
            if (channelHandlerContext == null || (channelHandlerContext = channelHandlerContext.pipeline()) == null) break block0;
            ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
            boolean bl = false;
            boolean bl2 = false;
            ChannelHandlerContext $this$apply = channelHandlerContext2;
            boolean bl3 = false;
            $this$apply.addLast(this.callEventGroup, new ChannelHandler[]{(ChannelHandler)new NettyApplicationCallHandler(this.userCoroutineContext, this.enginePipeline, ApplicationKt.getLog((Application)this.application))});
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ctx.close();
    }

    private final void startHttp2(ChannelHandlerContext context, Http2Headers headers2) {
        NettyRequestQueue requestQueue = new NettyRequestQueue(1, 1);
        NettyResponsePipeline responseWriter = new NettyResponsePipeline(context, WriterEncapsulation.Http2.INSTANCE, requestQueue, (CoroutineContext)this.handlerJob);
        NettyHttp2ApplicationCall call = new NettyHttp2ApplicationCall(this.application, context, headers2, this, this.handlerJob.plus((CoroutineContext)Dispatchers.getUnconfined()), this.userCoroutineContext);
        NettyHttp2Handler.Companion.setApplicationCall(context, call);
        requestQueue.schedule(call);
        requestQueue.close();
        responseWriter.ensureRunning();
    }

    @UseHttp2Push
    public final void startHttp2PushPromise$ktor_server_netty(@NotNull ChannelHandlerContext context, @NotNull ResponsePushBuilder builder) {
        Http2StreamChannel child;
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Channel channel = context.channel();
        if (channel == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.netty.handler.codec.http2.Http2StreamChannel");
        }
        Http2StreamChannel channel2 = (Http2StreamChannel)channel;
        int streamId = channel2.stream().id();
        ChannelHandler channelHandler = channel2.parent().pipeline().get(Http2MultiplexCodec.class);
        Intrinsics.checkNotNull((Object)channelHandler);
        Http2MultiplexCodec codec = (Http2MultiplexCodec)channelHandler;
        Http2Connection connection = codec.connection();
        if (!connection.remote().allowPushTo()) {
            return;
        }
        ChannelHandlerContext rootContext = channel2.parent().pipeline().lastContext();
        int promisedStreamId = connection.local().incrementAndGetNextStreamId();
        DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers();
        boolean bl = false;
        boolean bl2 = false;
        DefaultHttp2Headers $this$apply = defaultHttp2Headers;
        boolean bl3 = false;
        URLBuilder url = builder.getUrl();
        ParametersBuilder parameters = url.getParameters();
        if (parameters.isEmpty()) {
            string = url.getEncodedPath();
        } else {
            boolean bl4 = false;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl8 = false;
            $this$buildString.append(url.getEncodedPath());
            $this$buildString.append('?');
            HttpUrlEncodedKt.formUrlEncodeTo((Parameters)parameters.build(), (Appendable)$this$buildString);
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        String pathAndQuery = string;
        $this$apply.method((CharSequence)builder.getMethod().getValue());
        $this$apply.authority((CharSequence)(builder.getUrl().getHost() + ":" + builder.getUrl().getPort()));
        $this$apply.scheme((CharSequence)builder.getUrl().getProtocol().getName());
        $this$apply.path((CharSequence)pathAndQuery);
        DefaultHttp2Headers headers2 = defaultHttp2Headers;
        Http2StreamChannelBootstrap bs = new Http2StreamChannelBootstrap(channel2.parent()).handler((ChannelHandler)this);
        Http2StreamChannel http2StreamChannel = child = (Http2StreamChannel)bs.open().get();
        Intrinsics.checkNotNullExpressionValue((Object)http2StreamChannel, (String)"child");
        this.setId(http2StreamChannel, promisedStreamId);
        ChannelPromise promise = rootContext.newPromise();
        Http2Stream childStream = connection.local().createStream(promisedStreamId, false);
        Http2FrameStream http2FrameStream = child.stream();
        Intrinsics.checkNotNullExpressionValue((Object)http2FrameStream, (String)"child.stream()");
        Http2FrameCodec http2FrameCodec = (Http2FrameCodec)codec;
        Http2Stream http2Stream = childStream;
        Intrinsics.checkNotNullExpressionValue((Object)http2Stream, (String)"childStream");
        if (!this.setStreamAndProperty(http2FrameStream, http2FrameCodec, http2Stream)) {
            childStream.close();
            child.close();
            return;
        }
        codec.encoder().frameWriter().writePushPromise(rootContext, streamId, promisedStreamId, (Http2Headers)headers2, 0, promise);
        ChannelPromise channelPromise = promise;
        Intrinsics.checkNotNullExpressionValue((Object)channelPromise, (String)"promise");
        if (channelPromise.isSuccess()) {
            ChannelHandlerContext channelHandlerContext = child.pipeline().firstContext();
            Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"child.pipeline().firstContext()");
            this.startHttp2(channelHandlerContext, (Http2Headers)headers2);
        } else {
            promise.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, child, headers2){
                final /* synthetic */ NettyHttp2Handler this$0;
                final /* synthetic */ Http2StreamChannel $child;
                final /* synthetic */ DefaultHttp2Headers $headers;

                public final void operationComplete(Future<? super Void> future) {
                    future.get();
                    ChannelHandlerContext channelHandlerContext = this.$child.pipeline().firstContext();
                    Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"child.pipeline().firstContext()");
                    NettyHttp2Handler.access$startHttp2(this.this$0, channelHandlerContext, (Http2Headers)this.$headers);
                }
                {
                    this.this$0 = nettyHttp2Handler;
                    this.$child = http2StreamChannel;
                    this.$headers = defaultHttp2Headers;
                }
            });
        }
    }

    private final void setId(Http2StreamChannel $this$setId, int streamId) {
        Http2FrameStream http2FrameStream = $this$setId.stream();
        Intrinsics.checkNotNull((Object)http2FrameStream);
        Http2FrameStream stream = http2FrameStream;
        this.getIdField(stream).setInt(stream, streamId);
    }

    private final Field getStreamKeyField() {
        Lazy lazy = this.streamKeyField$delegate;
        NettyHttp2Handler nettyHttp2Handler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Field)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean setStreamAndProperty(Http2FrameStream $this$setStreamAndProperty, Http2FrameCodec codec, Http2Stream childStream) {
        Method method;
        Http2Connection.PropertyKey streamKey;
        block10: {
            block9: {
                Method method2;
                Method $this$firstOrNull$iv;
                block8: {
                    Field field = this.getStreamKeyField();
                    Object object = field != null ? field.get(codec) : null;
                    if (!(object instanceof Http2Connection.PropertyKey)) {
                        object = null;
                    }
                    Http2Connection.PropertyKey propertyKey = (Http2Connection.PropertyKey)object;
                    if (propertyKey == null) {
                        return false;
                    }
                    streamKey = propertyKey;
                    Method[] methodArray = $this$setStreamAndProperty.getClass().getDeclaredMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"javaClass.declaredMethods");
                    Method[] methodArray2 = methodArray;
                    boolean $i$f$firstOrNull = false;
                    void var8_8 = $this$firstOrNull$iv;
                    int n = ((void)var8_8).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var8_8[i];
                        boolean bl = false;
                        void v4 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                        if (!Intrinsics.areEqual((Object)v4.getName(), (Object)"setStreamAndProperty")) continue;
                        method2 = element$iv;
                        break block8;
                    }
                    method2 = method = null;
                }
                if (method2 == null) break block9;
                $this$firstOrNull$iv = method;
                boolean bl = false;
                boolean bl2 = false;
                Method it = $this$firstOrNull$iv;
                boolean bl3 = false;
                it.setAccessible(true);
                method = $this$firstOrNull$iv;
                if (method != null) break block10;
            }
            return false;
        }
        Method function = method;
        try {
            function.invoke((Object)$this$setStreamAndProperty, streamKey, childStream);
        }
        catch (Throwable cause) {
            return false;
        }
        return true;
    }

    private final Field getIdField(Http2FrameStream $this$idField) {
        return this.findIdField($this$idField.getClass());
    }

    private final Field findIdField(Class<?> $this$findIdField) {
        while (true) {
            Class<?> superclass;
            Field field;
            try {
                field = $this$findIdField.getDeclaredField("id");
            }
            catch (NoSuchFieldException t) {
                field = null;
            }
            Field f = field;
            if (f != null) {
                f.setAccessible(true);
                return f;
            }
            if ($this$findIdField.getSuperclass() == null) {
                throw (Throwable)new NoSuchFieldException("id field not found");
            }
            $this$findIdField = superclass;
        }
    }

    public NettyHttp2Handler(@NotNull EnginePipeline enginePipeline, @NotNull Application application, @NotNull EventExecutorGroup callEventGroup2, @NotNull CoroutineContext userCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)callEventGroup2, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)userCoroutineContext, (String)"userCoroutineContext");
        this.enginePipeline = enginePipeline;
        this.application = application;
        this.callEventGroup = callEventGroup2;
        this.userCoroutineContext = userCoroutineContext;
        this.handlerJob = SupervisorKt.SupervisorJob((Job)((Job)this.userCoroutineContext.get((CoroutineContext.Key)Job.Key)));
        this.streamKeyField$delegate = LazyKt.lazy((Function0)streamKeyField.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        ApplicationCallKey = AttributeKey.newInstance((String)"ktor.ApplicationCall");
    }

    public static final /* synthetic */ void access$startHttp2(NettyHttp2Handler $this, ChannelHandlerContext context, Http2Headers headers2) {
        $this.startHttp2(context, headers2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "Ljava/nio/channels/ClosedChannelException;", "Lkotlinx/coroutines/CopyableThrowable;", "errorCode", "", "(J)V", "getErrorCode", "()J", "message", "", "getMessage", "()Ljava/lang/String;", "createCopy", "ktor-server-netty"})
    private static final class Http2ClosedChannelException
    extends ClosedChannelException
    implements CopyableThrowable<Http2ClosedChannelException> {
        private final long errorCode;

        @Override
        @NotNull
        public String getMessage() {
            return "Got close frame with code " + this.errorCode;
        }

        @Nullable
        public Http2ClosedChannelException createCopy() {
            Http2ClosedChannelException http2ClosedChannelException = new Http2ClosedChannelException(this.errorCode);
            boolean bl = false;
            boolean bl2 = false;
            Http2ClosedChannelException it = http2ClosedChannelException;
            boolean bl3 = false;
            it.initCause(this);
            return http2ClosedChannelException;
        }

        public final long getErrorCode() {
            return this.errorCode;
        }

        public Http2ClosedChannelException(long errorCode) {
            this.errorCode = errorCode;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Companion;", "", "()V", "ApplicationCallKey", "Lio/netty/util/AttributeKey;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "kotlin.jvm.PlatformType", "newValue", "applicationCall", "Lio/netty/channel/ChannelHandlerContext;", "getApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;)Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "setApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;)V", "ktor-server-netty"})
    public static final class Companion {
        private final NettyHttp2ApplicationCall getApplicationCall(ChannelHandlerContext $this$applicationCall) {
            return (NettyHttp2ApplicationCall)((Object)$this$applicationCall.channel().attr(ApplicationCallKey).get());
        }

        private final void setApplicationCall(ChannelHandlerContext $this$applicationCall, NettyHttp2ApplicationCall newValue) {
            $this$applicationCall.channel().attr(ApplicationCallKey).set((Object)newValue);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

