/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.vector.QuantizationType;
import io.lettuce.core.vector.RawVector;
import java.nio.ByteBuffer;
import java.util.List;

public class RawVectorParser
implements ComplexDataParser<RawVector> {
    public static final RawVectorParser INSTANCE = new RawVectorParser();
    private static final String INT8 = "int8";
    private static final String FLOAT32 = "float32";
    private static final String BINARY = "binary";

    private RawVectorParser() {
    }

    @Override
    public RawVector parse(ComplexData dynamicData) {
        List<Object> data = this.verifyStructure(dynamicData);
        String quantTypeStr = data.get(0).toString();
        QuantizationType quantType = this.parseQuantizationType(quantTypeStr);
        ByteBuffer vectorData = this.parseVectorData(data.get(1));
        Double beforeNormalization = this.parseDouble(data.get(2));
        Double quantizationRange = null;
        if (quantType == QuantizationType.Q8 && data.size() > 3) {
            quantizationRange = this.parseDouble(data.get(3));
        }
        return new RawVector(quantType, vectorData, beforeNormalization, quantizationRange);
    }

    private List<Object> verifyStructure(ComplexData vembOutput) {
        List<Object> data;
        if (vembOutput == null) {
            throw new IllegalArgumentException("Failed while parsing VEMB RAW: vembOutput must not be null");
        }
        try {
            data = vembOutput.getDynamicList();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("Failed while parsing VEMB RAW: vembOutput must be a list", e);
        }
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Failed while parsing VEMB RAW: data must not be null or empty");
        }
        if (data.size() < 3) {
            throw new IllegalArgumentException("Failed while parsing VEMB RAW: data must contain at least 3 elements");
        }
        return data;
    }

    private Double parseDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private ByteBuffer parseVectorData(Object value) {
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        if (value instanceof String) {
            byte[] bytes = ((String)value).getBytes();
            return ByteBuffer.wrap(bytes);
        }
        throw new IllegalArgumentException("Failed while parsing VEMB RAW: vector data must be a binary blob");
    }

    private QuantizationType parseQuantizationType(String quantTypeStr) {
        switch (quantTypeStr.toLowerCase()) {
            case "int8": {
                return QuantizationType.Q8;
            }
            case "float32": {
                return QuantizationType.NO_QUANTIZATION;
            }
            case "binary": {
                return QuantizationType.BINARY;
            }
        }
        return null;
    }
}

