/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.netty4;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.netty4.NettyMeters;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;

public class NettyEventExecutorMetrics
implements MeterBinder {
    private final Iterable<EventExecutor> eventExecutors;
    private final Iterable<Tag> tags;

    public NettyEventExecutorMetrics(Iterable<EventExecutor> eventExecutors) {
        this(eventExecutors, Tags.empty());
    }

    public NettyEventExecutorMetrics(Iterable<EventExecutor> eventExecutors, Iterable<Tag> tags) {
        this.eventExecutors = eventExecutors;
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.eventExecutors.forEach(eventExecutor -> {
            if (eventExecutor instanceof SingleThreadEventExecutor) {
                SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)eventExecutor;
                Gauge.builder(NettyMeters.EVENT_EXECUTOR_TASKS_PENDING.getName(), () -> ((SingleThreadEventExecutor)singleThreadEventExecutor).pendingTasks()).tag(NettyMeters.EventExecutorTasksPendingKeyNames.NAME.asString(), singleThreadEventExecutor.threadProperties().name()).tags(this.tags).register(registry);
            }
        });
    }
}

