/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.MeterConvention;
import io.micrometer.core.instrument.binder.jvm.convention.JvmClassLoadingMeterConventions;
import io.micrometer.core.instrument.binder.jvm.convention.micrometer.MicrometerJvmClassLoadingMeterConventions;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

public class ClassLoaderMetrics
implements MeterBinder {
    private final JvmClassLoadingMeterConventions conventions;

    public ClassLoaderMetrics() {
        this(new MicrometerJvmClassLoadingMeterConventions());
    }

    public ClassLoaderMetrics(Iterable<Tag> extraTags) {
        this(new MicrometerJvmClassLoadingMeterConventions(Tags.of(extraTags)));
    }

    public ClassLoaderMetrics(JvmClassLoadingMeterConventions conventions) {
        this.conventions = conventions;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        MeterConvention<Object> currentClassCountConvention = this.conventions.currentClassCountConvention();
        Gauge.builder(currentClassCountConvention.getName(), classLoadingBean, ClassLoadingMXBean::getLoadedClassCount).tags(currentClassCountConvention.getTags(null)).description("The number of classes that are currently loaded in the Java virtual machine").baseUnit("classes").register(registry);
        MeterConvention<Object> unloadedConvention = this.conventions.unloadedConvention();
        FunctionCounter.builder(unloadedConvention.getName(), classLoadingBean, ClassLoadingMXBean::getUnloadedClassCount).tags(unloadedConvention.getTags(null)).description("The number of classes unloaded in the Java virtual machine").baseUnit("classes").register(registry);
        MeterConvention<Object> loadedConvention = this.conventions.loadedConvention();
        FunctionCounter.builder(loadedConvention.getName(), classLoadingBean, ClassLoadingMXBean::getTotalLoadedClassCount).tags(loadedConvention.getTags(null)).description("The number of classes loaded in the Java virtual machine").baseUnit("classes").register(registry);
    }
}

