/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmMemory;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.InternalLogger;
import io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@NonNullApi
@NonNullFields
public class JvmGcMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(JvmGcMetrics.class);
    private final boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    private final Iterable<Tag> tags;
    @Nullable
    private String youngGenPoolName;
    @Nullable
    private String oldGenPoolName;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmMemory.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (!JvmMemory.isOldGenPool(name)) continue;
            this.oldGenPoolName = name;
        }
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (!this.managementExtensionsPresent) {
            return;
        }
        double maxOldGen = JvmMemory.getOldGen().map(mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        AtomicLong maxDataSize = new AtomicLong((long)maxOldGen);
        Gauge.builder("jvm.gc.max.data.size", maxDataSize, AtomicLong::get).tags(this.tags).description("Max size of old generation memory pool").baseUnit("bytes").register(registry);
        AtomicLong liveDataSize = new AtomicLong(0L);
        Gauge.builder("jvm.gc.live.data.size", liveDataSize, AtomicLong::get).tags(this.tags).description("Size of old generation memory pool after a full GC").baseUnit("bytes").register(registry);
        Counter promotedBytes = Counter.builder("jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(registry);
        Counter allocatedBytes = Counter.builder("jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the young generation memory pool after one GC to before the next").register(registry);
        AtomicLong youngGenSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                long delta;
                if (!notification.getType().equals("com.sun.management.gc.notification")) {
                    return;
                }
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (JvmMemory.isConcurrentPhase(gcCause)) {
                    Timer.builder("jvm.gc.concurrent.phase.time").tags(this.tags).tags("action", gcAction, "cause", gcCause).description("Time spent in concurrent phase").register(registry).record(duration, TimeUnit.MILLISECONDS);
                } else {
                    Timer.builder("jvm.gc.pause").tags(this.tags).tags("action", gcAction, "cause", gcCause).description("Time spent in GC pause").register(registry).record(duration, TimeUnit.MILLISECONDS);
                }
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.oldGenPoolName != null) {
                    long oldBefore = before.get(this.oldGenPoolName).getUsed();
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    delta = oldAfter - oldBefore;
                    if (delta > 0L) {
                        promotedBytes.increment(delta);
                    }
                    if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                        liveDataSize.set(oldAfter);
                        long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                        maxDataSize.set(oldMaxAfter);
                    }
                }
                if (this.youngGenPoolName != null) {
                    long youngBefore = before.get(this.youngGenPoolName).getUsed();
                    long youngAfter = after.get(this.youngGenPoolName).getUsed();
                    delta = youngBefore - youngGenSizeAfter.get();
                    youngGenSizeAfter.set(youngAfter);
                    if (delta > 0L) {
                        allocatedBytes.increment(delta);
                    }
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, null, null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private static boolean isManagementExtensionsPresent() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            log.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, JvmGcMetrics.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            log.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    @NonNullApi
    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }
}

