/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Tracing;
import brave.baggage.BaggageField;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.brave.bridge.BraveBaggageInScope;
import io.micrometer.tracing.brave.bridge.BraveSpan;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class BraveBaggageManager
implements Closeable,
BaggageManager {
    private final List<String> tagFields;
    private final List<String> remoteFields;
    private final List<String> baggageFields;
    private @Nullable Tracer tracer;

    public BraveBaggageManager(List<String> tagFields, List<String> remoteFields) {
        this.tagFields = tagFields;
        this.remoteFields = remoteFields;
        this.baggageFields = BraveBaggageManager.baggageFields(tagFields, remoteFields);
    }

    private static List<String> baggageFields(List<String> tagFields, List<String> remoteFields) {
        HashSet<String> combined = new HashSet<String>(tagFields);
        combined.addAll(remoteFields);
        return new ArrayList<String>(combined);
    }

    public BraveBaggageManager() {
        this.tagFields = Collections.emptyList();
        this.remoteFields = Collections.emptyList();
        this.baggageFields = Collections.emptyList();
    }

    public BraveBaggageManager(List<String> tagFields) {
        this.tagFields = tagFields;
        this.remoteFields = Collections.emptyList();
        this.baggageFields = new ArrayList<String>(tagFields);
    }

    public Map<String, String> getAllBaggage() {
        return Objects.requireNonNull(BaggageField.getAllValues());
    }

    public Map<String, String> getAllBaggage(@Nullable TraceContext traceContext) {
        if (traceContext == null) {
            return this.getAllBaggage();
        }
        return BaggageField.getAllValues((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext));
    }

    public Baggage getBaggage(String name) {
        return this.createBaggage(name);
    }

    public @Nullable Baggage getBaggage(TraceContext traceContext, String name) {
        BaggageField baggageField = BaggageField.getByName((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext), (String)name);
        if (baggageField == null) {
            return null;
        }
        brave.Span span = this.currentSpan();
        return new BraveBaggageInScope(baggageField, BraveTraceContext.toBrave(traceContext), span, this.tagFields);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.baggage(name);
    }

    private BraveBaggageInScope baggage(String name, TraceContext traceContext) {
        brave.Span span = this.currentSpan();
        return new BraveBaggageInScope(BaggageField.create((String)name), BraveTraceContext.toBrave(traceContext), span, this.tagFields);
    }

    private BraveBaggageInScope baggage(String name) {
        brave.Span span = this.currentSpan();
        return new BraveBaggageInScope(BaggageField.create((String)name), span != null ? span.context() : null, span, this.tagFields);
    }

    private @Nullable brave.Span currentSpan() {
        if (this.tracer != null) {
            Span span = this.tracer.currentSpan();
            return BraveSpan.toBrave(span);
        }
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.tracer().currentSpan() : null;
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        return this.baggage(name).set(value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.baggage(name).makeCurrent(value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.baggage(name, traceContext).makeCurrent(traceContext, value);
    }

    @Override
    public void close() {
    }

    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public List<String> getBaggageFields() {
        return this.baggageFields;
    }
}

