/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import io.micrometer.tracing.ScopedSpan;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.util.Objects;

class BraveScopedSpan
implements ScopedSpan {
    final brave.ScopedSpan span;

    BraveScopedSpan(brave.ScopedSpan span) {
        this.span = span;
    }

    public boolean isNoop() {
        return this.span.isNoop();
    }

    public TraceContext context() {
        return new BraveTraceContext(this.span.context());
    }

    public ScopedSpan name(String name) {
        this.span.name(name);
        return this;
    }

    public ScopedSpan tag(String key, String value) {
        this.span.tag(key, value);
        return this;
    }

    public ScopedSpan event(String value) {
        this.span.annotate(value);
        return this;
    }

    public ScopedSpan error(Throwable throwable) {
        this.span.error(throwable);
        return this;
    }

    public void end() {
        this.span.finish();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BraveScopedSpan that = (BraveScopedSpan)o;
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.span);
    }
}

