/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.tracecontext.TraceparentFormat;
import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.brave.bridge.W3CBaggagePropagator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class W3CPropagation
extends Propagation.Factory
implements Propagation<String> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance((String)W3CPropagation.class.getName());
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private final @Nullable W3CBaggagePropagator baggagePropagator;
    private final @Nullable BaggageManager braveBaggageManager;

    public W3CPropagation(BaggageManager baggageManager, List<String> localFields) {
        this.baggagePropagator = new W3CBaggagePropagator(baggageManager, localFields);
        this.braveBaggageManager = baggageManager;
    }

    public W3CPropagation() {
        this.baggagePropagator = null;
        this.braveBaggageManager = null;
    }

    public Propagation<String> get() {
        return this;
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            Objects.requireNonNull(context, "context");
            Objects.requireNonNull(setter, "setter");
            setter.put(carrier, (Object)"traceparent", TraceparentFormat.get().write(context));
            this.addTraceState(setter, context, carrier);
            if (this.baggagePropagator != null) {
                this.baggagePropagator.injector(setter).inject(context, carrier);
            }
        };
    }

    private <R> void addTraceState(Propagation.Setter<R, String> setter, TraceContext context, R carrier) {
        if (carrier != null && this.braveBaggageManager != null) {
            Baggage baggage = this.braveBaggageManager.getBaggage(BraveTraceContext.fromBrave(context), "tracestate");
            if (baggage == null) {
                return;
            }
            String traceState = baggage.get(BraveTraceContext.fromBrave(context));
            if (StringUtils.isNotBlank((String)traceState)) {
                setter.put(carrier, (Object)"tracestate", traceState);
            }
        }
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        Objects.requireNonNull(getter, "getter");
        return carrier -> {
            String traceParent = getter.get(carrier, (Object)"traceparent");
            if (traceParent == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            TraceContext contextFromParentHeader = TraceparentFormat.get().parse((CharSequence)traceParent);
            if (contextFromParentHeader == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            String traceStateHeader = getter.get(carrier, (Object)"tracestate");
            TraceContextOrSamplingFlags context = this.context(contextFromParentHeader, traceStateHeader);
            if (this.baggagePropagator == null || this.braveBaggageManager == null) {
                return context;
            }
            return this.withBaggage(context, carrier, getter);
        };
    }

    private <R> TraceContextOrSamplingFlags withBaggage(TraceContextOrSamplingFlags context, R carrier, Propagation.Getter<R, String> getter) {
        if (context.context() == null) {
            return context;
        }
        return Objects.requireNonNull(this.baggagePropagator).contextWithBaggage(carrier, context, getter);
    }

    TraceContextOrSamplingFlags context(TraceContext contextFromParentHeader, @Nullable String traceStateHeader) {
        if (!StringUtils.isNotBlank((String)traceStateHeader)) {
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
        try {
            return TraceContextOrSamplingFlags.newBuilder((TraceContext)TraceContext.newBuilder().traceId(contextFromParentHeader.traceId()).traceIdHigh(contextFromParentHeader.traceIdHigh()).spanId(contextFromParentHeader.spanId()).sampled(contextFromParentHeader.sampled()).build()).build();
        }
        catch (IllegalArgumentException e) {
            logger.info("Unparseable tracestate header. Returning span context without state.");
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
    }
}

