/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.internal;

import io.micrometer.common.lang.internal.Contract;
import io.micrometer.common.util.StringUtils;
import org.jspecify.annotations.Nullable;

public final class SpanNameUtil {
    static final int MAX_NAME_LENGTH = 50;

    private SpanNameUtil() {
    }

    @Contract(value="!null -> !null")
    public static @Nullable String shorten(@Nullable String name) {
        if (!StringUtils.isNotBlank((String)name)) {
            return name;
        }
        int maxLength = Math.min(name.length(), 50);
        return name.substring(0, maxLength);
    }

    public static String toLowerHyphen(String name) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    result.append('-');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return SpanNameUtil.shorten(result.toString());
    }
}

