/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.internal;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public final class EncodingUtils {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = EncodingUtils.buildEncodingArray();
    private static final byte[] DECODING = EncodingUtils.buildDecodingArray();

    private EncodingUtils() {
    }

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    public static long[] fromString(@Nullable CharSequence chars) {
        if (chars == null || chars.length() == 0) {
            return new long[]{0L};
        }
        if (chars.length() == 32) {
            long high = HexCodec.lenientLowerHexToUnsignedLong(chars, 0, 16);
            long low = HexCodec.lenientLowerHexToUnsignedLong(chars, 16, 32);
            return new long[]{high, low};
        }
        return new long[]{HexCodec.lenientLowerHexToUnsignedLong(chars, 0, 16)};
    }

    public static String fromLong(long id) {
        return EncodingUtils.fromLongs(0L, id);
    }

    public static String fromLongs(long idHigh, long idLow) {
        if (idHigh == 0L) {
            return HexCodec.toLowerHex(idLow);
        }
        char[] chars = EncodingUtils.getTemporaryBuffer();
        EncodingUtils.longToBase16String(idHigh, chars, 0);
        EncodingUtils.longToBase16String(idLow, chars, 16);
        return new String(chars);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[32];
            charBuffer.set(chars);
        }
        return chars;
    }

    public static long longFromBase16String(CharSequence chars) {
        return EncodingUtils.longFromBase16String(chars, 0);
    }

    static long longFromBase16String(CharSequence chars, int offset) {
        EncodingUtils.isTrue(chars.length() >= offset + 16, "chars too small");
        return ((long)EncodingUtils.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)EncodingUtils.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    private static void isTrue(boolean expression, String text) {
        if (!expression) {
            throw new IllegalArgumentException(text);
        }
    }

    public static byte byteFromBase16String(CharSequence chars, int offset) {
        EncodingUtils.isTrue(chars.length() >= offset + 2, "chars too small");
        return EncodingUtils.decodeByte(chars.charAt(offset), chars.charAt(offset + 1));
    }

    private static byte decodeByte(char hi, char lo) {
        EncodingUtils.isTrue(lo < '\u0080' && DECODING[lo] != -1, "invalid character " + lo);
        EncodingUtils.isTrue(hi < '\u0080' && DECODING[hi] != -1, "invalid character " + hi);
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    public static boolean isValidBase16String(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char b = value.charAt(i);
            if (EncodingUtils.isDigit(b) || EncodingUtils.isLowercaseHexCharacter(b)) continue;
            return false;
        }
        return true;
    }

    public static void longToBase16String(long value, char[] dest, int destOffset) {
        EncodingUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        EncodingUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        EncodingUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        EncodingUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        EncodingUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        EncodingUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        EncodingUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        EncodingUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    public static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    private static boolean isLowercaseHexCharacter(char b) {
        return 'a' <= b && b <= 'f';
    }

    private static boolean isDigit(char b) {
        return '0' <= b && b <= '9';
    }

    static final class HexCodec {
        static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        private HexCodec() {
            throw new IllegalStateException("Can't instantiate a utility class");
        }

        static String toLowerHex(long v) {
            char[] data = RecyclableBuffers.parseBuffer();
            HexCodec.writeHexLong(data, 0, v);
            return new String(data, 0, 16);
        }

        static void writeHexLong(char[] data, int pos, long v) {
            HexCodec.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
            HexCodec.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
        }

        static void writeHexByte(char[] data, int pos, byte b) {
            data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
            data[pos + 1] = HEX_DIGITS[b & 0xF];
        }

        static long lenientLowerHexToUnsignedLong(CharSequence value, int beginIndex, int endIndex) {
            long result = 0L;
            int pos = beginIndex;
            while (pos < endIndex) {
                char c = value.charAt(pos++);
                result <<= 4;
                if (c >= '0' && c <= '9') {
                    result |= (long)(c - 48);
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    result |= (long)(c - 97 + 10);
                    continue;
                }
                return 0L;
            }
            return result;
        }
    }

    static final class RecyclableBuffers {
        private static final ThreadLocal<char[]> PARSE_BUFFER = new ThreadLocal();

        private RecyclableBuffers() {
            throw new IllegalStateException("Can't instantiate a utility class");
        }

        static char[] parseBuffer() {
            char[] idBuffer = PARSE_BUFFER.get();
            if (idBuffer == null) {
                idBuffer = new char[68];
                PARSE_BUFFER.set(idBuffer);
            }
            return idBuffer;
        }
    }
}

