/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core;

import io.micronaut.aot.core.Runtime;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Configuration {
    public boolean containsKey(String var1);

    @NonNull
    public String mandatoryValue(String var1);

    @Nullable
    public <T> T optionalValue(String var1, Function<Optional<String>, T> var2);

    @Nullable
    default public String optionalString(@NonNull String key, @Nullable String defaultValue) {
        return this.optionalValue(key, opt -> opt.orElse(defaultValue));
    }

    @NonNull
    default public List<String> stringList(@NonNull String key) {
        return this.stringList(key, "[,;]\\s*");
    }

    @NonNull
    default public List<String> stringList(@NonNull String key, @NonNull String separator) {
        return this.optionalValue(key, opt -> opt.map(string -> Arrays.stream(string.split(separator)).filter(Objects::nonNull).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList()));
    }

    default public boolean booleanValue(@NonNull String key, boolean defaultValue) {
        return this.optionalValue(key, s -> s.map(Boolean::parseBoolean).orElse(defaultValue));
    }

    default public boolean isFeatureEnabled(@NonNull String featureId) {
        return this.booleanValue(featureId + ".enabled", false);
    }

    @NonNull
    public Runtime getRuntime();
}

