/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.LoggerContextListenerModel;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.net.ssl.KeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.TrustManagerFactoryFactoryBean;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.std.sourcegen.ParentTagTagClassTuple;
import io.micronaut.core.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.xml.sax.InputSource;

class Logback14GeneratorHelper {
    private static final List<ParentTagTagClassTuple> TUPLE_LIST = Logback14GeneratorHelper.createTuplesList();

    Logback14GeneratorHelper() {
    }

    private static List<ParentTagTagClassTuple> createTuplesList() {
        return List.of(new ParentTagTagClassTuple("appender", "encoder", PatternLayoutEncoder.class), new ParentTagTagClassTuple("appender", "layout", PatternLayout.class), new ParentTagTagClassTuple("receiver", "ssl", SSLConfiguration.class), new ParentTagTagClassTuple("ssl", "parameters", SSLParametersConfiguration.class), new ParentTagTagClassTuple("ssl", "keyStore", KeyStoreFactoryBean.class), new ParentTagTagClassTuple("ssl", "trustStore", KeyManagerFactoryFactoryBean.class), new ParentTagTagClassTuple("ssl", "keyManagerFactory", SSLParametersConfiguration.class), new ParentTagTagClassTuple("ssl", "trustManagerFactory", TrustManagerFactoryFactoryBean.class), new ParentTagTagClassTuple("ssl", "secureRandom", SecureRandomFactoryBean.class));
    }

    private static void injectDefaultComponentClasses(Model aModel, Model parent) {
        Logback14GeneratorHelper.applyInjectionRules(aModel, parent);
        for (Model sub : aModel.getSubModels()) {
            Logback14GeneratorHelper.injectDefaultComponentClasses(sub, aModel);
        }
    }

    private static String unifiedTag(Model aModel) {
        String tag = aModel.getTag();
        char first = tag.charAt(0);
        if (Character.isUpperCase(first)) {
            char lower = Character.toLowerCase(first);
            return lower + tag.substring(1);
        }
        return tag;
    }

    private static void applyInjectionRules(Model aModel, Model parent) {
        ImplicitModel implicitModel;
        String className;
        if (parent == null) {
            return;
        }
        String parentTag = Logback14GeneratorHelper.unifiedTag(parent);
        String modelTag = Logback14GeneratorHelper.unifiedTag(aModel);
        if (aModel instanceof ImplicitModel && StringUtils.isEmpty((CharSequence)(className = (implicitModel = (ImplicitModel)aModel).getClassName()))) {
            for (ParentTagTagClassTuple ruleTuple : TUPLE_LIST) {
                if (!ruleTuple.parentTag.equals(parentTag) || !ruleTuple.tag.equals(modelTag)) continue;
                implicitModel.setClassName(ruleTuple.aClass.getName());
                break;
            }
        }
    }

    static MethodSpec configureMethod(String fileName, AOTContext aotContext) {
        Model model;
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        LoggerContext context = new LoggerContext();
        joranConfigurator.setContext((Context)context);
        try {
            URL logbackFile = aotContext.getAnalyzer().getApplicationContext().getClass().getClassLoader().getResource(fileName);
            if (logbackFile == null) {
                throw new IllegalStateException("Could not find " + fileName + " file on application classpath");
            }
            InputSource inputSource = new InputSource(logbackFile.openStream());
            SaxEventRecorder recorder = joranConfigurator.populateSaxEventRecorder(inputSource);
            model = joranConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
            Logback14GeneratorHelper.injectDefaultComponentClasses(model, null);
        }
        catch (JoranException | IOException e) {
            throw new RuntimeException(e);
        }
        final CodeBlock.Builder codeBuilder = CodeBlock.builder();
        final BeanDescriptionCache beanDescriptionCache = new BeanDescriptionCache((Context)context);
        ModelVisitor visitor = new ModelVisitor(){
            private final Map<String, Set<String>> loggerToAppenders = new HashMap<String, Set<String>>();
            private final Map<String, String> appenderRefToAppenderVarName = new HashMap<String, String>();
            private final Map<Model, String> modelToVarName = new HashMap<Model, String>();

            private String varNameOf(Model model) {
                return this.modelToVarName.computeIfAbsent(model, m -> {
                    Object var = this.toVarName(model);
                    if (this.modelToVarName.containsValue(var)) {
                        var = this.toVarName(model) + "_" + this.modelToVarName.size();
                    }
                    return var;
                });
            }

            private String toVarName(Model model) {
                String name;
                if (model instanceof NamedComponentModel) {
                    NamedComponentModel namedComponentModel = (NamedComponentModel)model;
                    name = namedComponentModel.getName();
                } else if (model instanceof LoggerModel) {
                    LoggerModel loggerModel = (LoggerModel)model;
                    name = loggerModel.getName();
                } else {
                    name = model.getTag();
                }
                return name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase(Locale.US);
            }

            @Override
            public void postVisit(Model model, Model parent) {
                ComponentModel componentModel;
                String className;
                if (model instanceof ComponentModel && (className = (componentModel = (ComponentModel)model).getClassName()) != null) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        if (ContextAware.class.isAssignableFrom(clazz)) {
                            codeBuilder.addStatement("$L.setContext(context)", new Object[]{this.varNameOf(model)});
                        }
                        if (LifeCycle.class.isAssignableFrom(clazz)) {
                            codeBuilder.addStatement("$L.start()", new Object[]{this.varNameOf(model)});
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                ModelVisitor.super.postVisit(model, parent);
            }

            @Override
            public void visitRootLogger(RootLoggerModel model, Model parent) {
                codeBuilder.addStatement("$T _rootLogger = loggerContext.getLogger($T.ROOT_LOGGER_NAME)", new Object[]{Logger.class, Logger.class});
                String level = model.getLevel();
                if (level != null) {
                    codeBuilder.addStatement("_rootLogger.setLevel($T.$L)", new Object[]{ClassName.get(Level.class), Level.toLevel((String)level)});
                }
                this.collectAppenders((Model)model, "_rootLogger");
            }

            @Override
            public void visitAppender(AppenderModel model, Model parent) {
                ClassName appenderName = ClassName.bestGuess((String)model.getClassName());
                String varName = this.varNameOf((Model)model);
                this.appenderRefToAppenderVarName.put(model.getName(), varName);
                codeBuilder.addStatement("$T $L = new $T()", new Object[]{appenderName, varName, appenderName});
            }

            @Override
            public void visitImplicit(ImplicitModel model, Model parent) {
                String className = model.getClassName();
                if (className == null && parent instanceof ComponentModel) {
                    this.generateSetterCode(model, parent);
                } else if (className != null) {
                    this.generateNewInstanceCode((ComponentModel)model, className);
                }
            }

            @Override
            public void postVisitImplicit(ImplicitModel model, Model parent) {
                String className = model.getClassName();
                if (className != null) {
                    this.generateSetterCode(model, parent);
                }
            }

            @Override
            public void visitLogger(LoggerModel model, Model parent) {
                String additivity;
                String loggerVarName = this.varNameOf((Model)model);
                codeBuilder.addStatement("$T $L = loggerContext.getLogger($S)", new Object[]{Logger.class, loggerVarName, model.getName()});
                String level = model.getLevel();
                if (level != null) {
                    codeBuilder.addStatement("$L.setLevel($T.$L)", new Object[]{loggerVarName, ClassName.get(Level.class), Level.toLevel((String)level)});
                }
                if ((additivity = model.getAdditivity()) != null) {
                    codeBuilder.addStatement("$L.setAdditive($L)", new Object[]{loggerVarName, Boolean.valueOf(additivity)});
                }
                this.collectAppenders((Model)model, loggerVarName);
            }

            @Override
            public void postVisitConfiguration(ConfigurationModel model, Model parent) {
                for (Map.Entry<String, Set<String>> entry : this.loggerToAppenders.entrySet()) {
                    String loggerName = entry.getKey();
                    for (String appenderRef : entry.getValue()) {
                        String varName = this.appenderRefToAppenderVarName.get(appenderRef);
                        if (varName == null) continue;
                        codeBuilder.addStatement("$L.addAppender($L)", new Object[]{loggerName, varName});
                    }
                }
            }

            @Override
            public void visitLoggerContextListener(LoggerContextListenerModel model, Model parent) {
                String className = model.getClassName();
                if (className == null) {
                    throw new IllegalStateException("LoggerContextListenerModel must have a class name");
                }
                this.generateNewInstanceCode((ComponentModel)model, className);
            }

            @Override
            public void postVisitLoggerContextListener(LoggerContextListenerModel model, Model parent) {
                String loggerContextListenerVarName = this.varNameOf((Model)model);
                codeBuilder.addStatement("loggerContext.addListener($L)", new Object[]{loggerContextListenerVarName});
            }

            @Override
            public void visitStatusListener(StatusListenerModel model, Model parent) {
                Class<?> type;
                String varName = this.varNameOf((Model)model);
                try {
                    type = Class.forName(model.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Could not find " + model.getClassName() + " on the AOT processor classpath", e);
                }
                codeBuilder.addStatement(CodeBlock.of((String)"$T $L = new $T()", (Object[])new Object[]{type, varName, type}));
                codeBuilder.addStatement("loggerContext.getStatusManager().add($L)", new Object[]{varName});
            }

            private void collectAppenders(Model model, String loggerVarName) {
                Set appenders = model.getSubModels().stream().filter(AppenderRefModel.class::isInstance).map(AppenderRefModel.class::cast).map(AppenderRefModel::getRef).collect(Collectors.toSet());
                this.loggerToAppenders.put(loggerVarName, appenders);
            }

            private void generateSetterCode(ImplicitModel model, Model parent) {
                if (!this.maybeGenerateAddOrSet(model, parent, BeanDescription::getSetter)) {
                    this.maybeGenerateAddOrSet(model, parent, BeanDescription::getAdder);
                }
            }

            private void generateNewInstanceCode(ComponentModel model, String className) {
                String varName = this.varNameOf((Model)model);
                ClassName elementType = ClassName.bestGuess((String)className);
                codeBuilder.addStatement("$T $L = new $T()", new Object[]{elementType, varName, elementType});
            }

            private boolean maybeGenerateAddOrSet(ImplicitModel model, Model parent, BiFunction<BeanDescription, String, Method> methodFinder) {
                try {
                    String ownerClassName = ((ComponentModel)parent).getClassName();
                    BeanDescription beanDescription = beanDescriptionCache.getBeanDescription(Class.forName(ownerClassName));
                    Method method = methodFinder.apply(beanDescription, model.getTag());
                    if (method != null) {
                        Class<?> parameterType = method.getParameterTypes()[0];
                        String parentVarName = this.varNameOf(parent);
                        if (model.getBodyText() == null) {
                            codeBuilder.addStatement("$L.$L($L)", new Object[]{parentVarName, method.getName(), this.varNameOf((Model)model)});
                            return true;
                        }
                        if (parameterType.isPrimitive()) {
                            Object value = this.toPrimitiveValue(model, parameterType);
                            codeBuilder.addStatement("$L.$L($L)", new Object[]{parentVarName, method.getName(), value});
                            return true;
                        }
                        if (String.class.equals(parameterType)) {
                            codeBuilder.addStatement("$L.$L($S)", new Object[]{parentVarName, method.getName(), model.getBodyText()});
                            return true;
                        }
                        try {
                            if (Charset.class.equals(parameterType)) {
                                parameterType.getDeclaredMethod("forName", String.class);
                                codeBuilder.addStatement("$L.$L($T.forName($S))", new Object[]{parentVarName, method.getName(), ClassName.get(parameterType), model.getBodyText()});
                            } else {
                                parameterType.getDeclaredMethod("valueOf", String.class);
                                codeBuilder.addStatement("$L.$L($T.valueOf($S))", new Object[]{parentVarName, method.getName(), ClassName.get(parameterType), model.getBodyText()});
                            }
                            return true;
                        }
                        catch (NoSuchMethodException e) {
                            throw new RuntimeException("Unable to convert type" + String.valueOf(parameterType));
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }

            private Object toPrimitiveValue(ImplicitModel model, Class<?> parameterType) {
                String bodyText = model.getBodyText();
                Object value = parameterType.equals(Boolean.TYPE) ? Boolean.valueOf(bodyText) : (parameterType.equals(Byte.TYPE) ? Byte.valueOf(bodyText) : (parameterType.equals(Character.TYPE) ? Character.valueOf(bodyText.charAt(0)) : (parameterType.equals(Double.TYPE) ? Double.valueOf(bodyText) : (parameterType.equals(Float.TYPE) ? Float.valueOf(bodyText) : (parameterType.equals(Integer.TYPE) ? Integer.valueOf(bodyText) : (parameterType.equals(Long.TYPE) ? Long.valueOf(bodyText) : (parameterType.equals(Short.TYPE) ? Short.valueOf(bodyText) : bodyText)))))));
                return value;
            }
        };
        visitor.visit(model);
        codeBuilder.addStatement(CodeBlock.of((String)"return $T.DO_NOT_INVOKE_NEXT_IF_ANY", (Object[])new Object[]{Configurator.ExecutionStatus.class}));
        return MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Configurator.ExecutionStatus.class).addParameter(LoggerContext.class, "loggerContext", new Modifier[0]).addCode(codeBuilder.build()).build();
    }

    static interface ModelVisitor {
        default public void visit(Model model) {
            this.visit(model, null);
        }

        default public void visit(Model model, Model parent) {
            this.preVisit(model, parent);
            model.getSubModels().forEach(m -> this.visit((Model)m, model));
            this.postVisit(model, parent);
        }

        default public void preVisit(Model model, Model parent) {
            if (model instanceof RootLoggerModel) {
                RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
                this.visitRootLogger(rootLoggerModel, parent);
            }
            if (model instanceof AppenderModel) {
                AppenderModel appenderModel = (AppenderModel)model;
                this.visitAppender(appenderModel, parent);
            }
            if (model instanceof ImplicitModel) {
                ImplicitModel implicitModel = (ImplicitModel)model;
                this.visitImplicit(implicitModel, parent);
            }
            if (model instanceof LoggerModel) {
                LoggerModel loggerModel = (LoggerModel)model;
                this.visitLogger(loggerModel, parent);
            }
            if (model instanceof ConfigurationModel) {
                ConfigurationModel configurationModel = (ConfigurationModel)model;
                this.visitConfiguration(configurationModel, parent);
            }
            if (model instanceof LoggerContextListenerModel) {
                LoggerContextListenerModel loggerContextListenerModel = (LoggerContextListenerModel)model;
                this.visitLoggerContextListener(loggerContextListenerModel, parent);
            }
            if (model instanceof StatusListenerModel) {
                StatusListenerModel statusListenerModel = (StatusListenerModel)model;
                this.visitStatusListener(statusListenerModel, parent);
            }
        }

        default public void postVisit(Model model, Model parent) {
            if (model instanceof RootLoggerModel) {
                RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
                this.postVisitRootLogger(rootLoggerModel, parent);
            }
            if (model instanceof AppenderModel) {
                AppenderModel appenderModel = (AppenderModel)model;
                this.postVisitAppender(appenderModel, parent);
            }
            if (model instanceof ImplicitModel) {
                ImplicitModel implicitModel = (ImplicitModel)model;
                this.postVisitImplicit(implicitModel, parent);
            }
            if (model instanceof LoggerModel) {
                LoggerModel loggerModel = (LoggerModel)model;
                this.postVisitLogger(loggerModel, parent);
            }
            if (model instanceof ConfigurationModel) {
                ConfigurationModel configurationModel = (ConfigurationModel)model;
                this.postVisitConfiguration(configurationModel, parent);
            }
            if (model instanceof LoggerContextListenerModel) {
                LoggerContextListenerModel loggerContextListenerModel = (LoggerContextListenerModel)model;
                this.postVisitLoggerContextListener(loggerContextListenerModel, parent);
            }
        }

        default public void visitRootLogger(RootLoggerModel model, Model parent) {
        }

        default public void postVisitRootLogger(RootLoggerModel model, Model parent) {
        }

        default public void visitAppender(AppenderModel model, Model parent) {
        }

        default public void postVisitAppender(AppenderModel model, Model parent) {
        }

        default public void visitImplicit(ImplicitModel model, Model parent) {
        }

        default public void postVisitImplicit(ImplicitModel model, Model parent) {
        }

        default public void visitLogger(LoggerModel model, Model parent) {
        }

        default public void postVisitLogger(LoggerModel model, Model parent) {
        }

        default public void visitConfiguration(ConfigurationModel model, Model parent) {
        }

        default public void postVisitConfiguration(ConfigurationModel model, Model parent) {
        }

        default public void visitLoggerContextListener(LoggerContextListenerModel model, Model parent) {
        }

        default public void postVisitLoggerContextListener(LoggerContextListenerModel model, Model parent) {
        }

        default public void visitStatusListener(StatusListenerModel model, Model parent) {
        }
    }
}

