/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.aot;

import io.micronaut.build.aot.AbstractMicronautAotMojo;
import io.micronaut.build.services.CompilerService;
import io.micronaut.build.services.DependencyResolutionService;
import io.micronaut.build.services.ExecutorService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractMicronautAotCliMojo
extends AbstractMicronautAotMojo {
    public static final String EXEC_MAVEN_PLUGIN_GROUP = "org.codehaus.mojo";
    public static final String EXEC_MAVEN_PLUGIN_ARTIFACT = "exec-maven-plugin";
    public static final String EXEC_MAVEN_PLUGIN_VERSION_PROPERTY = "exec-maven-plugin.version";
    public static final String DEFAULT_EXEC_MAVEN_PLUGIN_VERSION = "3.0.0";
    private static final String[] AOT_MODULES = new String[]{"api", "cli", "std-optimizers"};
    @Parameter(property="micronaut.aot.packageName")
    protected String packageName;
    private final ExecutorService executorService;
    private final DependencyResolutionService dependencyResolutionService;
    @Parameter
    private List<Dependency> aotDependencies;

    @Inject
    public AbstractMicronautAotCliMojo(CompilerService compilerService, ExecutorService executorService, MavenProject mavenProject, MavenSession mavenSession, RepositorySystem repositorySystem, DependencyResolutionService dependencyResolutionService) {
        super(compilerService, mavenProject, mavenSession, repositorySystem);
        this.executorService = executorService;
        this.dependencyResolutionService = dependencyResolutionService;
    }

    protected abstract List<String> getExtraArgs() throws MojoExecutionException;

    @Override
    protected void doExecute() throws MojoExecutionException, DependencyResolutionException {
        if (StringUtils.isEmpty((String)this.packageName)) {
            throw new MojoExecutionException("micronaut.aot.packageName is not set, and is required if AOT is enabled");
        }
        try {
            this.getLog().info((CharSequence)"Packaging project");
            this.compilerService.compileProject(true);
            InvocationResult packagingResult = this.compilerService.packageProject();
            if (packagingResult.getExitCode() != 0) {
                this.getLog().error((CharSequence)"Error when packaging the project: ", (Throwable)packagingResult.getExecutionException());
            } else {
                this.executeAot();
            }
        }
        catch (MavenInvocationException e) {
            this.getLog().error((CharSequence)"Error when packaging project", (Throwable)e);
        }
    }

    private void executeAot() throws DependencyResolutionException, MojoExecutionException {
        this.getLog().info((CharSequence)"Executing Micronaut AOT analysis");
        Xpp3Dom config = this.createExecPluginConfig();
        this.executorService.executeGoal(EXEC_MAVEN_PLUGIN_GROUP, EXEC_MAVEN_PLUGIN_ARTIFACT, this.mavenProject.getProperties().getProperty(EXEC_MAVEN_PLUGIN_VERSION_PROPERTY, DEFAULT_EXEC_MAVEN_PLUGIN_VERSION), "exec", config);
    }

    private Xpp3Dom createExecPluginConfig() throws DependencyResolutionException, MojoExecutionException {
        List<String> aotClasspath = this.resolveAotClasspath();
        List<String> aotPluginsClasspath = this.resolveAotPluginsClasspath();
        List<String> applicationClasspath = this.resolveApplicationClasspath();
        ArrayList<String> classpath = new ArrayList<String>(aotPluginsClasspath.size() + applicationClasspath.size());
        classpath.addAll(aotClasspath);
        classpath.addAll(aotPluginsClasspath);
        classpath.addAll(applicationClasspath);
        MojoExecutor.Element[] runnerArgs = (MojoExecutor.Element[])Stream.concat(Stream.of("-classpath", String.join((CharSequence)File.pathSeparator, aotClasspath), "io.micronaut.aot.cli.Main", "--classpath=" + String.join((CharSequence)File.pathSeparator, classpath), "--package=" + this.packageName, "--runtime=" + this.runtime), this.getExtraArgs().stream()).map(arg -> MojoExecutor.element((String)"argument", (String)arg)).toArray(MojoExecutor.Element[]::new);
        return MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"executable", (String)"java"), MojoExecutor.element((String)"arguments", (MojoExecutor.Element[])runnerArgs)});
    }

    private List<String> resolveApplicationClasspath() {
        String projectJar = new File(this.mavenProject.getBuild().getDirectory(), this.mavenProject.getBuild().getFinalName() + ".jar").getAbsolutePath();
        ArrayList<String> result = new ArrayList<String>();
        result.add(projectJar);
        String classpath = this.compilerService.buildClasspath(this.compilerService.resolveDependencies("runtime"));
        result.addAll(Arrays.asList(classpath.split(File.pathSeparator)));
        return result;
    }

    private List<String> resolveAotClasspath() throws DependencyResolutionException {
        Stream<Artifact> aotArtifacts = Arrays.stream(AOT_MODULES).map(m -> new DefaultArtifact("io.micronaut.aot:micronaut-aot-" + m + ":" + this.micronautAotVersion));
        return DependencyResolutionService.toClasspath(this.dependencyResolutionService.artifactResultsFor(aotArtifacts, false));
    }

    private List<String> resolveAotPluginsClasspath() throws DependencyResolutionException {
        if (this.aotDependencies != null && !this.aotDependencies.isEmpty()) {
            Stream<Artifact> aotPlugins = this.aotDependencies.stream().map(d -> new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getType(), d.getVersion()));
            return DependencyResolutionService.toClasspath(this.dependencyResolutionService.artifactResultsFor(aotPlugins, false));
        }
        return Collections.emptyList();
    }
}

