/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.aot;

import io.micronaut.build.aot.AbstractMicronautAotCliMojo;
import io.micronaut.build.services.CompilerService;
import io.micronaut.build.services.DependencyResolutionService;
import io.micronaut.build.services.ExecutorService;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="aot-sample-config", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AotSampleMojo
extends AbstractMicronautAotCliMojo {
    public static final String SAMPLE_AOT_PROPERTIES_FILE_NAME = "aot.properties";
    public static final String NAME = "aot-sample-config";

    @Inject
    public AotSampleMojo(CompilerService compilerService, ExecutorService executorService, MavenProject mavenProject, MavenSession mavenSession, RepositorySystem repositorySystem, DependencyResolutionService dependencyResolutionService) {
        super(compilerService, executorService, mavenProject, mavenSession, repositorySystem, dependencyResolutionService);
    }

    @Override
    protected List<String> getExtraArgs() {
        return Arrays.asList("--config", this.outputFile(SAMPLE_AOT_PROPERTIES_FILE_NAME).getAbsolutePath());
    }

    @Override
    protected void onSuccess(File outputDir) {
        File sampleFile = new File(outputDir, SAMPLE_AOT_PROPERTIES_FILE_NAME);
        if (sampleFile.exists()) {
            this.getLog().info((CharSequence)("Sample configuration file written to " + sampleFile));
        }
    }

    @Override
    String getName() {
        return NAME;
    }
}

