/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientOptions;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.Optional;
import javax.validation.constraints.NotBlank;

public abstract class AbstractMongoConfiguration {
    private String uri = "mongodb://localhost";
    private final ApplicationConfiguration applicationConfiguration;

    public AbstractMongoConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @NotBlank
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        if (StringUtils.isNotEmpty((CharSequence)uri)) {
            this.uri = uri;
        }
    }

    public Optional<ConnectionString> getConnectionString() {
        if (StringUtils.isNotEmpty((CharSequence)this.uri)) {
            return Optional.of(new ConnectionString(this.uri));
        }
        return Optional.empty();
    }

    public abstract MongoClientOptions buildOptions();

    protected String getApplicationName() {
        return this.applicationConfiguration.getName().orElse("application");
    }
}

