/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.reactivestreams.client.MongoClients;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public abstract class AbstractReactiveMongoConfiguration {
    private String uri;
    private final ApplicationConfiguration applicationConfiguration;
    private List<Codec<?>> codecList = Collections.emptyList();
    private List<CodecRegistry> codecRegistries = Collections.emptyList();
    private Collection<String> packageNames;
    private boolean automaticClassModels = true;

    protected AbstractReactiveMongoConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public void codecs(List<Codec<?>> codecList) {
        if (codecList != null) {
            this.codecList = codecList;
        }
    }

    public void codecRegistries(List<CodecRegistry> codecRegistries) {
        if (codecRegistries != null) {
            this.codecRegistries = codecRegistries;
        }
    }

    public void packages(Collection<String> packageNames) {
        if (packageNames != null) {
            this.packageNames = packageNames;
        }
    }

    public List<Codec<?>> getCodecs() {
        return this.codecList;
    }

    public List<CodecRegistry> getCodecRegistries() {
        return this.codecRegistries;
    }

    @NotBlank
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        Optional<ConnectionString> connectionString = this.getConnectionString();
        if (connectionString.isPresent()) {
            ConnectionString cs = connectionString.get();
            this.getClientSettings().applyConnectionString(cs);
            this.getServerSettings().applyConnectionString(cs);
            this.getClusterSettings().applyConnectionString(cs);
            this.getPoolSettings().applyConnectionString(cs);
            this.getSslSettings().applyConnectionString(cs);
            this.getSocketSettings().applyConnectionString(cs);
        }
    }

    public void setPackageNames(Collection<String> packageNames) {
        this.packageNames = packageNames;
    }

    public void setAutomaticClassModels(boolean automaticClassModels) {
        this.automaticClassModels = automaticClassModels;
    }

    public Optional<ConnectionString> getConnectionString() {
        if (StringUtils.isNotEmpty((CharSequence)this.uri)) {
            return Optional.of(new ConnectionString(this.uri));
        }
        return Optional.empty();
    }

    public abstract ClusterSettings.Builder getClusterSettings();

    public abstract MongoClientSettings.Builder getClientSettings();

    public abstract ServerSettings.Builder getServerSettings();

    public abstract ConnectionPoolSettings.Builder getPoolSettings();

    public abstract SocketSettings.Builder getSocketSettings();

    public abstract SslSettings.Builder getSslSettings();

    public MongoClientSettings buildSettings() {
        ClusterSettings.Builder clusterSettings = this.getClusterSettings();
        SslSettings.Builder sslSettings = this.getSslSettings();
        ConnectionPoolSettings.Builder poolSettings = this.getPoolSettings();
        SocketSettings.Builder socketSettings = this.getSocketSettings();
        ServerSettings.Builder serverSettings = this.getServerSettings();
        MongoClientSettings.Builder clientSettings = this.getClientSettings();
        clientSettings.applicationName(this.getApplicationName());
        clientSettings.applyToClusterSettings(builder -> builder.applySettings(clusterSettings.build()));
        clientSettings.applyToServerSettings(builder -> builder.applySettings(serverSettings.build()));
        clientSettings.applyToConnectionPoolSettings(builder -> builder.applySettings(poolSettings.build()));
        clientSettings.applyToSocketSettings(builder -> builder.applySettings(socketSettings.build()));
        clientSettings.applyToSslSettings(builder -> builder.applySettings(sslSettings.build()));
        ArrayList<CodecRegistry> codecRegistries = new ArrayList<CodecRegistry>();
        codecRegistries.add(MongoClients.getDefaultCodecRegistry());
        if (this.codecRegistries != null) {
            codecRegistries.addAll(this.codecRegistries);
        }
        if (this.codecList != null) {
            codecRegistries.add(CodecRegistries.fromCodecs(this.codecList));
        }
        PojoCodecProvider.Builder builder2 = PojoCodecProvider.builder();
        if (CollectionUtils.isNotEmpty(this.packageNames)) {
            builder2.register(this.packageNames.toArray(new String[0]));
        }
        codecRegistries.add(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{builder2.automatic(this.automaticClassModels).build()}));
        clientSettings.codecRegistry(CodecRegistries.fromRegistries(codecRegistries));
        return clientSettings.build();
    }

    protected String getApplicationName() {
        return this.applicationConfiguration.getName().orElse("application");
    }
}

