/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import io.micronaut.configuration.mongo.reactive.AbstractMongoConfiguration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.runtime.ApplicationConfiguration;

@Requirements(value={@Requires(property="mongodb"), @Requires(classes={MongoClientOptions.class})})
@ConfigurationProperties(value="mongodb")
public class DefaultMongoConfiguration
extends AbstractMongoConfiguration {
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="options")
    protected MongoClientOptions.Builder clientOptions = MongoClientOptions.builder();

    public DefaultMongoConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    @Override
    public MongoClientOptions buildOptions() {
        this.clientOptions.applicationName(this.getApplicationName());
        return this.clientOptions.build();
    }

    public MongoClientURI buildURI() {
        this.clientOptions.applicationName(this.getApplicationName());
        return new MongoClientURI(this.getUri(), this.clientOptions);
    }
}

