/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive;

import com.mongodb.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import io.micronaut.configuration.mongo.reactive.AbstractReactiveMongoConfiguration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.env.Environment;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.List;
import javax.inject.Inject;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

@EachProperty(value="mongodb.servers")
public class NamedReactiveMongoConfiguration
extends AbstractReactiveMongoConfiguration {
    @ConfigurationBuilder(prefixes={""})
    protected MongoClientSettings.Builder clientSettings = MongoClientSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="cluster")
    protected ClusterSettings.Builder clusterSettings = ClusterSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="server")
    protected ServerSettings.Builder serverSettings = ServerSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="connection-pool")
    protected ConnectionPoolSettings.Builder poolSettings = ConnectionPoolSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="socket")
    protected SocketSettings.Builder socketSettings = SocketSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="ssl")
    protected SslSettings.Builder sslSettings = SslSettings.builder();
    private final String serverName;

    public NamedReactiveMongoConfiguration(@Parameter String serverName, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.serverName = serverName;
    }

    @Inject
    public NamedReactiveMongoConfiguration(@Parameter String serverName, ApplicationConfiguration applicationConfiguration, Environment environment) {
        super(applicationConfiguration);
        this.serverName = serverName;
        if (environment != null) {
            this.setPackageNames(environment.getPackages());
        }
    }

    @Override
    @Inject
    public void codecs(List<Codec<?>> codecList) {
        super.codecs(codecList);
    }

    @Override
    @Inject
    public void codecRegistries(List<CodecRegistry> codecRegistries) {
        super.codecRegistries(codecRegistries);
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public ClusterSettings.Builder getClusterSettings() {
        return this.clusterSettings;
    }

    @Override
    public MongoClientSettings.Builder getClientSettings() {
        return this.clientSettings;
    }

    @Override
    public ServerSettings.Builder getServerSettings() {
        return this.serverSettings;
    }

    @Override
    public ConnectionPoolSettings.Builder getPoolSettings() {
        return this.poolSettings;
    }

    @Override
    public SocketSettings.Builder getSocketSettings() {
        return this.socketSettings;
    }

    @Override
    public SslSettings.Builder getSslSettings() {
        return this.sslSettings;
    }

    @Override
    protected String getApplicationName() {
        String applicationName = super.getApplicationName();
        return applicationName + "-" + this.serverName;
    }
}

