/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive.test;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterSettings;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import io.micronaut.core.io.socket.SocketUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractMongoProcessFactory {
    MongodProcess process;

    AbstractMongoProcessFactory() {
    }

    void startEmbeddedMongoIfPossible(@Nullable ConnectionString connectionString, @Nullable ClusterSettings.Builder clusterSettings) throws IOException {
        int port;
        ClusterSettings settings;
        List hosts;
        if (connectionString != null) {
            String first = (String)connectionString.getHosts().get(0);
            int port2 = new ServerAddress(first).getPort();
            if (SocketUtils.isTcpPortAvailable((int)port2)) {
                this.startMongoProcess(port2);
            }
        } else if (clusterSettings != null && (hosts = (settings = clusterSettings.build()).getHosts()).size() == 1 && SocketUtils.isTcpPortAvailable((int)(port = ((ServerAddress)hosts.get(0)).getPort()))) {
            this.startMongoProcess(port);
        }
    }

    private void startMongoProcess(int port) throws IOException {
        IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.PRODUCTION).net(new Net("localhost", port, Network.localhostIsIPv6())).build();
        MongodExecutable mongodExecutable = (MongodExecutable)MongodStarter.getDefaultInstance().prepare((IExecutableProcessConfig)mongodConfig);
        this.process = (MongodProcess)mongodExecutable.start();
    }
}

