/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive.test;

import com.mongodb.ConnectionString;
import com.mongodb.connection.ClusterSettings;
import de.flapdoodle.embed.mongo.MongodProcess;
import io.micronaut.configuration.mongo.reactive.DefaultReactiveMongoConfiguration;
import io.micronaut.configuration.mongo.reactive.test.AbstractMongoProcessFactory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;

@Requirements(value={@Requires(classes={MongodProcess.class}), @Requires(beans={DefaultReactiveMongoConfiguration.class}), @Requires(env={"test"}), @Requires(property="mongodb.embedded.enabled", notEquals="false", defaultValue="true")})
@Singleton
public class ReactiveMongoProcessFactory
extends AbstractMongoProcessFactory
implements BeanCreatedEventListener<DefaultReactiveMongoConfiguration>,
Closeable {
    public DefaultReactiveMongoConfiguration onCreated(BeanCreatedEvent<DefaultReactiveMongoConfiguration> event) {
        DefaultReactiveMongoConfiguration configuration = (DefaultReactiveMongoConfiguration)event.getBean();
        try {
            Optional<ConnectionString> connectionString = configuration.getConnectionString();
            ClusterSettings.Builder clusterSettings = configuration.getClusterSettings();
            this.startEmbeddedMongoIfPossible(connectionString.orElse(null), clusterSettings);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error starting Embedded MongoDB server: " + e.getMessage(), (Throwable)e);
        }
        return configuration;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.process != null) {
            this.process.stop();
        }
    }
}

