/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import java.util.Collections;

@Internal
public class FindAllSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    protected FindAllSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Iterable<?> iterable;
        Class rt = context.getReturnType().getType();
        if (rt.isInstance(iterable = this.findAll(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_ALL))) {
            return iterable;
        }
        return this.operations.getConversionService().convert(iterable, context.getReturnType().asArgument()).orElse(Collections.emptyList());
    }
}

