/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@Internal
final class MapperUtils {
    private MapperUtils() {
    }

    static Collection<?> toCollection(Object value) {
        Collection<Object> collection;
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList aCollection;
            collection = aCollection = (ArrayList)value;
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            collection = new ArrayList(CollectionUtils.iterableToList((Iterable)iterable));
        } else if (value.getClass().isArray()) {
            Object[] arr = (Object[])value;
            collection = Arrays.asList(arr);
        } else if (value instanceof Array) {
            Object[] arr;
            Array arrayValue = (Array)value;
            try {
                arr = (Object[])arrayValue.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException("Unable to read SQL array", (Throwable)e);
            }
            collection = Arrays.asList(arr);
        } else {
            collection = Collections.singleton(value);
        }
        return collection;
    }
}

