/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import java.util.Optional;

@Internal
public abstract class AbstractDataSourceTransactionManagerCondition
implements Condition {
    protected abstract String getTransactionManagerName();

    public boolean matches(ConditionContext context) {
        String dataSourceName;
        BeanResolutionContext beanResolutionContext = context.getBeanResolutionContext();
        if (beanResolutionContext == null) {
            dataSourceName = "default";
        } else {
            Qualifier currentQualifier = beanResolutionContext.getCurrentQualifier();
            if (currentQualifier instanceof Named) {
                Named named = (Named)currentQualifier;
                dataSourceName = named.getName();
            } else {
                dataSourceName = "default";
            }
        }
        return this.transactionManagerProperty(context, dataSourceName).map(name -> name.equals(this.getTransactionManagerName())).orElse(true);
    }

    @Deprecated
    @NonNull
    private Optional<String> transactionManagerProperty(@NonNull ConditionContext context, @NonNull String dataSourceName) {
        String propertyName = "datasources." + dataSourceName + ".transactionManager";
        Optional property = context.getProperty(propertyName, String.class);
        if (property.isPresent()) {
            return property;
        }
        String lowerKebapCasePropertyName = "datasources." + dataSourceName + ".transaction-manager";
        return context.getProperty(lowerKebapCasePropertyName, String.class);
    }
}

