/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.generator.aggregator.AnnotationsAggregator;
import io.micronaut.jsonschema.generator.aggregator.TypeAggregator;
import io.micronaut.jsonschema.generator.loaders.FileLoader;
import io.micronaut.jsonschema.generator.loaders.FileProcessor;
import io.micronaut.jsonschema.generator.utils.GeneratorContext;
import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfig;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ObjectDefBuilder;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@Internal
public final class SourceGenerator {
    private static String inputFileName = null;
    private static VisitorContext.Language language;
    private static Path outputPath;
    private static String outputPackageName;
    private final io.micronaut.sourcegen.generator.SourceGenerator sourceGenerator;
    private final GeneratorContext context;
    private String discriminatorProperty = "";

    public SourceGenerator(String lang) {
        this(VisitorContext.Language.valueOf((String)lang.toUpperCase()), new GeneratorContext());
    }

    public SourceGenerator(VisitorContext.Language language, GeneratorContext context) {
        this.sourceGenerator = SourceGenerators.findByLanguage((VisitorContext.Language)language).orElse(null);
        if (this.sourceGenerator == null) {
            throw new RuntimeException("No source generator found for language " + String.valueOf(language));
        }
        SourceGenerator.language = language;
        this.context = context;
    }

    public File generate(SourceGeneratorConfig config) throws IOException {
        this.context.setConfiguration(config);
        outputPath = config.outputPath();
        outputPackageName = config.outputPackageName();
        if (config.inputFolder() == null) {
            Schema jsonSchema = FileProcessor.getJsonSchema(config);
            assert (jsonSchema != null);
            String string = inputFileName = SourceGenerator.getInputFileName() != null ? SourceGenerator.getInputFileName() : config.getInputName();
            if (config.outputFileName() != null && !config.outputFileName().isBlank()) {
                String outputFileName = config.outputFileName();
                if (config.outputFileName().contains(".")) {
                    outputFileName = outputFileName.substring(0, outputFileName.indexOf(46));
                }
                return this.generateFromSchema(jsonSchema, config.outputPath(), config.outputPackageName(), outputFileName);
            }
            this.saveDefinitions(jsonSchema);
            return this.generateDefinitions(jsonSchema, config.outputPath(), config.outputPackageName());
        }
        this.generateFolder(config);
        return null;
    }

    private void generateFolder(SourceGeneratorConfig config) throws IOException {
        HashMap<Schema, String> schemas = new HashMap<Schema, String>();
        Path jsonFolder = config.inputFolder();
        try (Stream<Path> paths = Files.walk(jsonFolder, new FileVisitOption[0]).filter(file -> file.toString().endsWith(".schema.json"));){
            paths.forEach(path -> {
                Schema jsonSchema = new FileLoader(path.toFile()).load();
                assert (jsonSchema != null);
                inputFileName = path.toString().substring(jsonFolder.toString().length() + 1);
                schemas.put(jsonSchema, inputFileName);
                this.saveDefinitions(jsonSchema);
            });
        }
        catch (IOException e) {
            throw new FileSystemException(jsonFolder.toString());
        }
        schemas.forEach((jsonSchema, fileName) -> {
            try {
                inputFileName = fileName;
                this.generateDefinitions((Schema)jsonSchema, config.outputPath(), config.outputPackageName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveDefinitions(Schema jsonSchema) {
        String schemaName = jsonSchema.hasTitle() ? jsonSchema.getTitle() : inputFileName.substring(0, inputFileName.indexOf(46));
        String finalSchemaName = TypeAggregator.getClassName(schemaName);
        if (jsonSchema.hasOneOf()) {
            jsonSchema.getOneOf().forEach(oneOf -> {
                if (oneOf.has$ref()) {
                    Object ref = oneOf.get$ref();
                    if (((String)ref).indexOf("#") == 0) {
                        ref = inputFileName + (String)ref;
                    }
                    this.context.addOneOf((String)ref);
                } else {
                    this.context.addOneOf((Schema)oneOf);
                }
            });
        }
        if (jsonSchema.has$defs()) {
            jsonSchema.get$defs().forEach((key, value) -> {
                if (key.equals("//")) {
                    if (!jsonSchema.hasDescription()) {
                        jsonSchema.setDescription(String.valueOf(value));
                    } else {
                        jsonSchema.setDescription(jsonSchema.getDescription() + "<br>" + String.valueOf(value));
                    }
                } else if (value.hasOneOf() && jsonSchema.hasDiscriminator()) {
                    this.context.addDefinition(inputFileName + "#/$defs/" + key, (TypeDef)TypeDef.THIS, true);
                } else {
                    this.context.addDefinition(inputFileName + "#/$defs/" + key, (Schema)value);
                }
            });
        }
        this.context.addDefinition(inputFileName + "#/" + finalSchemaName, jsonSchema);
    }

    private File generateDefinitions(Schema jsonSchema, Path outputPath, String packageName) throws IOException {
        String schemaName = jsonSchema.hasTitle() ? jsonSchema.getTitle() : inputFileName.substring(0, inputFileName.indexOf(46));
        schemaName = TypeAggregator.getClassName(schemaName);
        File topLevelObject = this.generateFromSchema(jsonSchema, outputPath, packageName, schemaName);
        if (jsonSchema.has$defs()) {
            jsonSchema.get$defs().entrySet().stream().filter(definition -> !((String)definition.getKey()).equals("//") && this.context.isDefinitionClass(inputFileName + "#/$defs/" + (String)definition.getKey())).forEach(definition -> {
                try {
                    String className = TypeAggregator.getClassName((String)definition.getKey());
                    this.generateFromSchema((Schema)definition.getValue(), outputPath, packageName, className);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (Map.Entry<String, Schema> oneOf : this.context.getOneOfsToGenerate()) {
            String className = oneOf.getKey().substring(oneOf.getKey().lastIndexOf(47) + 1);
            this.generateFromSchema(oneOf.getValue(), outputPath, packageName, className);
        }
        return topLevelObject;
    }

    private File generateFromSchema(Schema jsonSchema, Path outputPath, String packageName, String fileName) throws IOException {
        ObjectType type;
        String decidedFileName = FileProcessor.getFileName(jsonSchema, Optional.ofNullable(fileName));
        String simpleName = decidedFileName.substring(0, decidedFileName.lastIndexOf(46));
        if (jsonSchema.isEnum()) {
            type = ObjectType.ENUM;
        } else if (jsonSchema.hasOneOf()) {
            type = jsonSchema.hasProperties() || jsonSchema.hasType() || jsonSchema.hasAllOf() ? ObjectType.CLASS : ObjectType.INTERFACE;
        } else if (this.context.isInheriting(simpleName) || this.shouldBeAClass(jsonSchema)) {
            type = ObjectType.CLASS;
        } else if (TypeAggregator.getTypeDefFromJson(jsonSchema, this.context).equals(TypeDef.OBJECT)) {
            type = ObjectType.RECORD;
        } else {
            return null;
        }
        File outputFile = FileProcessor.getOutputFile(outputPath, packageName, decidedFileName);
        String builderClassName = packageName + "." + simpleName;
        try (FileWriter writer = new FileWriter(outputFile);){
            EnumDef objectDef = switch (type) {
                case ObjectType.ENUM -> this.buildEnum(jsonSchema, builderClassName);
                case ObjectType.CLASS -> this.buildClass(jsonSchema, builderClassName);
                case ObjectType.INTERFACE -> this.buildInterface(jsonSchema, builderClassName);
                case ObjectType.RECORD -> this.buildRecord(jsonSchema, builderClassName);
                default -> throw new IllegalStateException("Unexpected enum type: " + String.valueOf((Object)type));
            };
            this.sourceGenerator.write((ObjectDef)objectDef, (Writer)writer);
        }
        if (jsonSchema.hasOneOf()) {
            if (type == ObjectType.CLASS) {
                this.context.addDefinition(inputFileName + "/superClass", (TypeDef)ClassTypeDef.of((String)simpleName), true);
            } else if (type == ObjectType.INTERFACE) {
                this.context.addDefinition(inputFileName + "/superInterface", (TypeDef)ClassTypeDef.of((String)simpleName), true);
            }
        }
        return outputFile;
    }

    public EnumDef buildEnum(Schema jsonSchema, String builderClassName) {
        EnumDef.EnumDefBuilder enumBuilder = (EnumDef.EnumDefBuilder)((EnumDef.EnumDefBuilder)EnumDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(ClassTypeDef.of((String)"io.micronaut.serde.annotation.Serdeable"));
        boolean isComplexEnum = false;
        LinkedHashMap cases = new LinkedHashMap();
        LinkedHashMap<String, Object> enumValues = new LinkedHashMap<String, Object>();
        int counter = 0;
        for (Object anEnum : jsonSchema.getEnumValues()) {
            String enumConst2 = anEnum.toString();
            Object constName2 = TypeAggregator.isOnlyLetters(enumConst2) ? TypeAggregator.getConstantName(enumConst2) : TypeAggregator.unicodeToString(enumConst2);
            if (enumValues.containsKey(constName2)) {
                constName2 = (String)constName2 + "_" + ++counter;
            }
            enumValues.put((String)constName2, anEnum);
            if (((String)constName2).equals(anEnum)) continue;
            isComplexEnum = true;
        }
        boolean finalIsComplexEnum = isComplexEnum;
        enumValues.forEach((constName, enumConst) -> {
            if (!finalIsComplexEnum) {
                enumBuilder.addEnumConstant(constName);
            } else {
                enumBuilder.addEnumConstant(constName, new ExpressionDef[]{ExpressionDef.constant((Object)enumConst)});
                cases.put(ExpressionDef.constant((Object)enumConst), new ExpressionDef.Constant((TypeDef)TypeDef.THIS, constName));
            }
        });
        if (isComplexEnum) {
            Schema.Type valueType;
            Object defaultValue = jsonSchema.hasDefaultValue() && enumValues.containsValue(jsonSchema.getDefaultValue()) ? (ExpressionDef)cases.get(ExpressionDef.constant((Object)jsonSchema.getDefaultValue())) : ExpressionDef.nullValue();
            Schema.Type type = valueType = jsonSchema.hasType() ? (Schema.Type)jsonSchema.getType().get(0) : Schema.Type.STRING;
            if (valueType.equals((Object)Schema.Type.NULL)) {
                valueType = Schema.Type.STRING;
            }
            TypeDef valueTypeDef = TypeAggregator.TYPE_MAP_NULLABLE.get(valueType.toString().toLowerCase(Locale.ENGLISH));
            ((EnumDef.EnumDefBuilder)enumBuilder.addField(((FieldDef.FieldDefBuilder)FieldDef.builder((String)"value").ofType(valueTypeDef).addModifiers(new Modifier[]{Modifier.PUBLIC})).build()).addAllFieldsConstructor(new Modifier[]{Modifier.PRIVATE}).addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(ClassTypeDef.of((String)"com.fasterxml.jackson.annotation.JsonValue"))).returns(valueTypeDef).build((aThis, parameters) -> aThis.field("value", valueTypeDef).returning()))).addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"statusOf").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).addAnnotation(ClassTypeDef.of((String)"com.fasterxml.jackson.annotation.JsonCreator"))).returns((TypeDef)TypeDef.THIS).addParameter("value", valueTypeDef).build((arg_0, arg_1) -> SourceGenerator.lambda$buildEnum$9(cases, (ExpressionDef)defaultValue, arg_0, arg_1)));
        }
        this.addFields(jsonSchema, (ObjectDefBuilder)enumBuilder);
        return enumBuilder.build();
    }

    private RecordDef buildRecord(Schema jsonSchema, String builderClassName) {
        RecordDef.RecordDefBuilder objectBuilder = (RecordDef.RecordDefBuilder)((RecordDef.RecordDefBuilder)RecordDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(ClassTypeDef.of((String)"io.micronaut.serde.annotation.Serdeable"));
        this.addFields(jsonSchema, (ObjectDefBuilder)objectBuilder);
        return objectBuilder.build();
    }

    private ClassDef buildClass(Schema jsonSchema, String builderClassName) {
        ClassDef.ClassDefBuilder objectBuilder = (ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(ClassTypeDef.of((String)"io.micronaut.serde.annotation.Serdeable"));
        if (this.context.hasDefinition(inputFileName + "/superClass")) {
            TypeDef superClass = this.context.getDefinitionType(inputFileName + "/superClass");
            objectBuilder.superclass((ClassTypeDef)superClass);
        } else if (this.context.hasDefinition(inputFileName + "/superInterface")) {
            TypeDef superInterface = this.context.getDefinitionType(inputFileName + "/superInterface");
            objectBuilder.addSuperinterface(superInterface);
        } else {
            this.addDiscriminatorAnnotations(jsonSchema, (ObjectDefBuilder)objectBuilder);
        }
        this.addFields(jsonSchema, (ObjectDefBuilder)objectBuilder);
        if (!this.discriminatorProperty.isBlank()) {
            objectBuilder.addAnnotation(AnnotationsAggregator.getJsonTypeInfoAnn(this.discriminatorProperty));
            Map properties = jsonSchema.getProperties();
            if (properties.containsKey(this.discriminatorProperty)) {
                objectBuilder.addField(((FieldDef.FieldDefBuilder)FieldDef.builder((String)this.discriminatorProperty).ofType((TypeDef)TypeDef.STRING).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL})).initializer((ExpressionDef)ExpressionDef.constant((Object)((Schema)properties.get(this.discriminatorProperty)).getConstValue())).build());
            }
        }
        return objectBuilder.build();
    }

    private InterfaceDef buildInterface(Schema jsonSchema, String builderClassName) {
        InterfaceDef.InterfaceDefBuilder objectBuilder = (InterfaceDef.InterfaceDefBuilder)((InterfaceDef.InterfaceDefBuilder)InterfaceDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(ClassTypeDef.of((String)"io.micronaut.serde.annotation.Serdeable"));
        if (jsonSchema.hasDiscriminator()) {
            this.addDiscriminatorAnnotations(jsonSchema, (ObjectDefBuilder)objectBuilder);
            if (!this.discriminatorProperty.isBlank()) {
                objectBuilder.addAnnotation(AnnotationsAggregator.getJsonTypeInfoAnn(this.discriminatorProperty));
            }
        }
        return objectBuilder.build();
    }

    private void addFields(Schema jsonSchema, ObjectDefBuilder builder) {
        if (jsonSchema.hasDescription()) {
            builder.addJavadoc(this.getJavadoc(jsonSchema.getDescription()));
        }
        if (jsonSchema.hasProperties()) {
            List requiredProperties = jsonSchema.getRequired() != null ? jsonSchema.getRequired() : new ArrayList();
            jsonSchema.getProperties().forEach((key, value) -> this.addField(builder, (String)key, (Schema)value, requiredProperties.contains(key)));
            if (jsonSchema.hasAdditionalProperties() && !jsonSchema.getAdditionalProperties().equals(Schema.FALSE)) {
                this.addAdditionalField(jsonSchema, builder);
            }
        }
    }

    private void addAdditionalField(Schema jsonSchema, ObjectDefBuilder builder) {
        Object mapType = jsonSchema.getAdditionalProperties().equals(Schema.TRUE) ? TypeDef.OBJECT : TypeAggregator.getTypeDefFromJson(jsonSchema.getAdditionalProperties(), this.context);
        ClassTypeDef type = TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of(HashMap.class), (TypeDef[])new TypeDef[]{TypeDef.STRING, mapType});
        if (builder instanceof ClassDef.ClassDefBuilder) {
            ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)builder;
            classDefBuilder.addField(FieldDef.builder((String)"unknownFields").ofType((TypeDef)type).build());
        } else {
            builder.addProperty(PropertyDef.builder((String)"unknownFields").ofType((TypeDef)type).build());
        }
        builder.addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"getUnknownFields").addModifiers(new Modifier[]{Modifier.PUBLIC})).returns((TypeDef)type).addAnnotation(ClassTypeDef.of((String)"com.fasterxml.jackson.annotation.JsonAnyGetter"))).build((arg_0, arg_1) -> SourceGenerator.lambda$addAdditionalField$11(builder, (TypeDef)type, arg_0, arg_1)));
        builder.addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"setUnknownFields").addModifiers(new Modifier[]{Modifier.PUBLIC})).returns((TypeDef)TypeDef.VOID).addAnnotation(ClassTypeDef.of((String)"com.fasterxml.jackson.annotation.JsonAnySetter"))).addParameter("name", (TypeDef)TypeDef.STRING).addParameter("value", (TypeDef)mapType).build((arg_0, arg_1) -> SourceGenerator.lambda$addAdditionalField$12(builder, (TypeDef)type, (TypeDef)mapType, arg_0, arg_1)));
    }

    private void addField(ObjectDefBuilder objectBuilder, String propertyName, Schema schema, boolean isRequired) {
        TypeDef propertyType;
        List<AnnotationDef> annotations;
        if (propertyName.equals(this.discriminatorProperty)) {
            return;
        }
        String name = TypeAggregator.getPropertyName(propertyName);
        PropertyDef.PropertyDefBuilder propertyDef = (PropertyDef.PropertyDefBuilder)PropertyDef.builder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!name.equals(propertyName)) {
            propertyDef.addAnnotation(AnnotationsAggregator.getJsonPropertyAnn(propertyName));
        }
        if (!(annotations = AnnotationsAggregator.getAnnotations(schema, propertyType = this.getPropertyType(objectBuilder, schema, name), isRequired)).isEmpty()) {
            propertyType = propertyType.annotated(annotations);
        }
        propertyDef.ofType(propertyType);
        if (schema.hasDescription()) {
            propertyDef.addJavadoc(this.getJavadoc(schema.getDescription()));
        }
        PropertyDef property = propertyDef.build();
        if (schema.hasConstValue() && objectBuilder instanceof ClassDef.ClassDefBuilder) {
            ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)objectBuilder;
            FieldDef.FieldDefBuilder fieldDefBuilder = ((FieldDef.FieldDefBuilder)FieldDef.builder((String)name).ofType(property.getType()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL})).initializer((ExpressionDef)ExpressionDef.constant((Object)schema.getConstValue()));
            property.getAnnotations().forEach(arg_0 -> ((FieldDef.FieldDefBuilder)fieldDefBuilder).addAnnotation(arg_0));
            property.getJavadoc().forEach(arg_0 -> ((FieldDef.FieldDefBuilder)fieldDefBuilder).addJavadoc(arg_0));
            FieldDef fieldDef = fieldDefBuilder.build();
            classDefBuilder.addField(fieldDef).addMethod(MethodDef.builder((String)("get" + StringUtils.capitalize((String)name))).build((aThis, methodParameters) -> aThis.field(fieldDef).returning()));
            return;
        }
        objectBuilder.addProperty(property);
    }

    private TypeDef getPropertyType(ObjectDefBuilder objectBuilder, Schema schema, String name) {
        TypeDef propertyType = TypeAggregator.getTypeDefFromJson(schema, this.context);
        if (schema.isEnum()) {
            propertyType = this.getEnumType(objectBuilder, name, schema);
        } else if (propertyType.equals(TypeDef.of(List.class))) {
            propertyType = this.getListTypeDef(objectBuilder, name, schema);
        } else if (propertyType.equals(TypeDef.OBJECT) && schema.hasProperties()) {
            propertyType = this.buildInnerType(objectBuilder, name, schema);
        } else if (propertyType.equals(TypeDef.OBJECT) && schema.hasAdditionalProperties()) {
            if (schema.getAdditionalProperties().equals(Schema.TRUE)) {
                return TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of(Map.class), (TypeDef[])new TypeDef[]{TypeDef.STRING, TypeDef.OBJECT});
            }
            return TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of(Map.class), (TypeDef[])new TypeDef[]{TypeDef.STRING, this.getPropertyType(objectBuilder, schema.getAdditionalProperties(), name + "Item")});
        }
        return propertyType;
    }

    private void addDiscriminatorAnnotations(Schema jsonSchema, ObjectDefBuilder objectBuilder) {
        if (!jsonSchema.hasDiscriminator()) {
            return;
        }
        Schema.SchemaDiscriminator discriminator = jsonSchema.getDiscriminator();
        this.discriminatorProperty = discriminator.propertyName();
        objectBuilder.addAnnotation(AnnotationsAggregator.getJsonSubTypesAnn(discriminator.mapping(), this.context));
    }

    private String getJavadoc(String description) {
        if (!this.context.getConfiguration().javadoc().replaceHTML()) {
            return description;
        }
        if (description.isBlank()) {
            return "";
        }
        return description.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;").replace("\n", "<br>\n").trim();
    }

    private TypeDef getEnumType(ObjectDefBuilder objectBuilder, String propertyName, Schema schema) {
        EnumDef enumDef = this.buildEnum(schema, StringUtils.capitalize((String)propertyName));
        objectBuilder.addInnerType((ObjectDef)enumDef);
        return enumDef.asTypeDef();
    }

    private TypeDef getListTypeDef(ObjectDefBuilder objectBuilder, String propertyName, Schema schema) {
        Schema items;
        Schema schema2 = items = schema.getItems() != null ? schema.getItems() : schema.getContains();
        if (items == null) {
            return TypeDef.OBJECT;
        }
        TypeDef propertyType = this.getPropertyType(objectBuilder, items, propertyName);
        if (propertyType instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)propertyType;
            propertyType = primitive.wrapperType();
        }
        List<AnnotationDef> annotations = AnnotationsAggregator.getAnnotations(items, propertyType, false);
        return TypeDef.parameterized(schema.isUniqueItems() != null && schema.isUniqueItems() != false ? Set.class : List.class, (TypeDef[])new TypeDef[]{propertyType.annotated(annotations)});
    }

    private TypeDef buildInnerType(ObjectDefBuilder objectBuilder, String propertyName, Schema schema) {
        Object builder = this.shouldBeAClass(schema) ? this.buildClass(schema, StringUtils.capitalize((String)propertyName)) : this.buildRecord(schema, StringUtils.capitalize((String)propertyName));
        objectBuilder.addInnerType((ObjectDef)builder);
        return ClassTypeDef.of((String)builder.getName());
    }

    private boolean shouldBeAClass(Schema schema) {
        if (this.context.getConfiguration().recordAdoptionStrategy() == SourceGeneratorConfig.RecordAdoptionStrategy.ALWAYS_CLASS) {
            return true;
        }
        boolean hasOverLimitParameters = schema.hasProperties() && schema.getProperties().size() > 255;
        return hasOverLimitParameters || schema.hasAdditionalProperties() || schema.hasConstValue();
    }

    public static String getInputFileName() {
        return inputFileName;
    }

    public static void setInputFileName(String inputFileName) {
        SourceGenerator.inputFileName = inputFileName;
    }

    public static Path getOutputPath() {
        return outputPath;
    }

    public static String getOutputPackageName() {
        return outputPackageName;
    }

    public static VisitorContext.Language getLanguage() {
        return language;
    }

    private static /* synthetic */ StatementDef lambda$addAdditionalField$12(ObjectDefBuilder builder, TypeDef type, TypeDef mapType, VariableDef.This aThis, List parameters) {
        VariableDef.Local unknownField = builder instanceof ClassDef.ClassDefBuilder ? aThis.field("unknownFields", type) : new VariableDef.Local("unknownFields", type);
        return StatementDef.multi((StatementDef[])new StatementDef[]{((ExpressionDef)unknownField).ifNull(((VariableDef)unknownField).assign((ExpressionDef)ClassTypeDef.of(HashMap.class).instantiate(new ExpressionDef[0]))), ((ExpressionDef)unknownField).invoke("put", mapType, parameters)});
    }

    private static /* synthetic */ StatementDef lambda$addAdditionalField$11(ObjectDefBuilder builder, TypeDef type, VariableDef.This aThis, List parameters) {
        if (builder instanceof ClassDef.ClassDefBuilder) {
            return aThis.field("unknownFields", type).returning();
        }
        return new VariableDef.Local("unknownFields", type).returning();
    }

    private static /* synthetic */ StatementDef lambda$buildEnum$9(LinkedHashMap cases, ExpressionDef defaultValue, VariableDef.This aThis, List parameters) {
        return ((VariableDef.MethodParameter)parameters.get(0)).asExpressionSwitch((TypeDef)TypeDef.STRING, (Map)cases, defaultValue).returning();
    }

    private static enum ObjectType {
        CLASS,
        RECORD,
        INTERFACE,
        ENUM;

    }
}

