/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.aggregator;

import com.fasterxml.jackson.core.JsonPointer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.loaders.UrlLoader;
import io.micronaut.jsonschema.generator.utils.GeneratorContext;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.lang.model.SourceVersion;

@Internal
public final class TypeAggregator {
    public static final Map<String, TypeDef> TYPE_MAP;
    public static final Map<String, TypeDef> TYPE_MAP_NULLABLE;

    public static TypeDef getTypeDefFromJson(Schema schema, GeneratorContext context) {
        Object typeDef;
        Schema.Type type;
        if (schema.hasOneOf()) {
            return TypeDef.OBJECT;
        }
        if (schema.hasAnyOf()) {
            return TypeAggregator.chooseFromAnyOf(schema.getAnyOf(), context);
        }
        if (schema.isEnum()) {
            return TypeDef.OBJECT;
        }
        boolean nullable = false;
        if (schema.hasType() && schema.getType().size() > 1) {
            if (schema.getType().size() == 2 && schema.getType().contains(Schema.Type.NULL)) {
                nullable = true;
                List typeList = schema.getType();
                typeList.remove(Schema.Type.NULL);
                schema.setType(typeList);
            } else {
                System.err.println("Only one type is allowed per schema. In case of multiple types, the variable is generated as a java.lang.Object.");
                return TypeDef.OBJECT;
            }
        }
        Schema.Type type2 = type = schema.hasType() ? (Schema.Type)schema.getType().get(0) : Schema.Type.OBJECT;
        if (type.equals((Object)Schema.Type.STRING) && schema.getFormat() != null) {
            String format;
            typeDef = switch (format = schema.getFormat()) {
                case "date" -> ClassTypeDef.of(LocalDate.class);
                case "date-time", "time" -> ClassTypeDef.of(ZonedDateTime.class);
                case "duration" -> ClassTypeDef.of(Duration.class);
                case "ipv4" -> ClassTypeDef.of(Inet4Address.class);
                case "ipv6" -> ClassTypeDef.of(Inet6Address.class);
                case "uuid" -> ClassTypeDef.of(UUID.class);
                case "uri", "iri" -> ClassTypeDef.of(URI.class);
                case "json-pointer" -> ClassTypeDef.of(JsonPointer.class);
                default -> TypeDef.STRING;
            };
        } else if (type.equals((Object)Schema.Type.NUMBER) && schema.getPattern() != null) {
            typeDef = schema.getPattern().contains(".") ? (nullable ? TypeDef.Primitive.FLOAT_WRAPPER : TypeDef.Primitive.FLOAT) : (nullable ? TypeDef.Primitive.INT_WRAPPER : TypeDef.Primitive.INT);
        } else if (schema.has$ref()) {
            Object ref = schema.get$ref();
            if (((String)ref).equals("#")) {
                return TypeDef.THIS;
            }
            if (((String)ref).indexOf("#") == 0) {
                ref = SourceGenerator.getInputFileName() + (String)ref;
            }
            String location = ((String)ref).substring(0, ((String)ref).indexOf("#"));
            String originalFileName = SourceGenerator.getInputFileName();
            if (!context.hasDefinition((String)ref) && UrlLoader.isValidUrl(location) && !location.equals(originalFileName)) {
                try {
                    SourceGenerator generator = new SourceGenerator(SourceGenerator.getLanguage(), context);
                    SourceGenerator.setInputFileName(location);
                    generator.generate(context.getConfiguration().toBuilder().withInputStream(null).withInputFolder(null).withJsonUrl(location).withJsonFile(null).build());
                    SourceGenerator.setInputFileName(originalFileName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            typeDef = context.getDefinitionType((String)ref);
        } else {
            String typeKey = type.toString().toLowerCase(Locale.ENGLISH);
            typeDef = nullable ? TYPE_MAP_NULLABLE.get(typeKey) : TYPE_MAP.get(typeKey);
        }
        if (typeDef == null) {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        }
        return typeDef;
    }

    private static TypeDef chooseFromAnyOf(List<Schema> schemas, GeneratorContext context) {
        if (schemas.isEmpty()) {
            return null;
        }
        if (schemas.size() == 1) {
            return TypeAggregator.getTypeDefFromJson(schemas.get(0), context);
        }
        if (schemas.size() == 2) {
            Schema nullSchema = new Schema();
            nullSchema.setType(List.of(Schema.Type.NULL));
            if (schemas.contains(nullSchema)) {
                schemas.remove(nullSchema);
                return TypeAggregator.getTypeDefFromJson(schemas.get(0), context);
            }
        }
        boolean sameType = true;
        for (int i = 0; i < schemas.size() - 1; ++i) {
            if (schemas.get(i).hasType() && !schemas.get(i).getType().equals(schemas.get(i + 1).getType())) {
                sameType = false;
                continue;
            }
            if (schemas.get(i).hasType() && schemas.get(i + 1).hasType()) continue;
            sameType = false;
        }
        if (sameType) {
            Schema.Type type = (Schema.Type)schemas.get(0).getType().get(0);
            return TYPE_MAP.get(type.toString().toLowerCase(Locale.ENGLISH));
        }
        return TypeDef.OBJECT;
    }

    public static String getConstantName(String input) {
        if (input.equals(input.toUpperCase())) {
            return input;
        }
        String cleanedInput = input.replaceAll("[-_]", " ").replaceAll("(?<!^)(?=[A-Z])", " ").replaceAll("[^a-zA-Z0-9 ]", "").trim();
        while (!Character.isJavaIdentifierStart(cleanedInput.charAt(0))) {
            cleanedInput = cleanedInput.substring(1);
        }
        CharSequence[] words = cleanedInput.split("\\s+");
        try {
            if (words.length == 0 || words[0].isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < words.length; ++i) {
                words[i] = ((String)words[i]).toUpperCase();
            }
            return String.join((CharSequence)"_", words);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The enum constant name is not an acceptable identifier name.");
        }
    }

    public static String getClassName(String input) {
        String identifier = TypeAggregator.getPropertyName(input);
        while (!Character.isLetter(identifier.charAt(0))) {
            identifier = identifier.substring(1);
        }
        return StringUtils.capitalize((String)identifier);
    }

    public static String getPropertyName(String input) {
        if (SourceVersion.isName(input)) {
            return input;
        }
        if (SourceVersion.isKeyword(input)) {
            return input + "_json";
        }
        String cleanedInput = input.replaceAll("[-_]", " ").replaceAll("[^a-zA-Z0-9 ]", "").trim();
        while (!Character.isJavaIdentifierStart(cleanedInput.charAt(0))) {
            cleanedInput = cleanedInput.substring(1);
        }
        String[] words = cleanedInput.split("\\s+");
        StringBuilder camelCaseString = new StringBuilder();
        if (words.length == 0 || words[0].isEmpty()) {
            throw new IllegalArgumentException("Property name is not an acceptable variable name");
        }
        for (int i = 0; i < words.length; ++i) {
            String word = words[i].trim();
            if (word.isEmpty()) continue;
            if (i == 0) {
                camelCaseString.append(word.toLowerCase());
                continue;
            }
            camelCaseString.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase());
        }
        return camelCaseString.toString();
    }

    public static String unicodeToString(String input) {
        StringBuilder newName = new StringBuilder();
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '-' || c.charValue() == '_') {
                newName.append('_');
                continue;
            }
            if (!Character.isLetter(c.charValue())) {
                String charName = Character.getName(c.charValue());
                newName.append(' ').append(charName, 0, charName.lastIndexOf(32) != -1 ? charName.lastIndexOf(32) : charName.length()).append(' ');
                continue;
            }
            newName.append(Character.toUpperCase(c.charValue()));
        }
        String cleanedInput = newName.toString().replaceAll("[-_]", " ").replaceAll("[^a-zA-Z0-9 ]", "").trim();
        return cleanedInput.replaceAll(" ", "_");
    }

    public static boolean isOnlyLetters(String input) {
        boolean isLetters = true;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isLetter(c.charValue()) || Character.isWhitespace(c.charValue())) continue;
            isLetters = false;
        }
        return isLetters;
    }

    static {
        TYPE_MAP_NULLABLE = CollectionUtils.mapOf((Object[])new Object[]{"integer", TypeDef.Primitive.INT_WRAPPER, "boolean", TypeDef.Primitive.BOOLEAN_WRAPPER, "array", TypeDef.of(List.class), "void", TypeDef.VOID, "string", TypeDef.STRING, "object", TypeDef.OBJECT, "number", TypeDef.Primitive.FLOAT_WRAPPER, "null", TypeDef.OBJECT});
        TYPE_MAP = new HashMap<String, TypeDef>();
        TYPE_MAP.putAll(TYPE_MAP_NULLABLE);
        TYPE_MAP.put("integer", (TypeDef)TypeDef.Primitive.INT);
        TYPE_MAP.put("boolean", (TypeDef)TypeDef.Primitive.BOOLEAN);
        TYPE_MAP.put("number", (TypeDef)TypeDef.Primitive.FLOAT);
    }
}

