/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.loaders;

import io.micronaut.jsonschema.generator.loaders.SchemaLoader;
import io.micronaut.jsonschema.model.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class StreamLoader
implements SchemaLoader {
    private final InputStream inputStream;

    public StreamLoader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public Schema load() {
        try {
            String jsonString = new String(this.inputStream.readAllBytes(), StandardCharsets.UTF_8);
            this.inputStream.close();
            return (Schema)JSON_MAPPER.readValue(jsonString, Schema.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load schema from input stream ", e);
        }
    }
}

