/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.loaders;

import io.micronaut.jsonschema.generator.loaders.SchemaLoader;
import io.micronaut.jsonschema.model.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlLoader
implements SchemaLoader {
    private static List<String> allowedUrlPatterns = List.of("^https://.*/.*.json");
    private final String url;

    public UrlLoader(String url) {
        this.url = url;
    }

    @Override
    public Schema load() {
        Schema schema;
        block11: {
            String jsonString = null;
            InputStream inputStream = UrlLoader.downloadAsStream(this.url);
            try {
                jsonString = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                schema = (Schema)JSON_MAPPER.readValue(jsonString, Schema.class);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return schema;
    }

    private static InputStream downloadAsStream(String fileUrl) throws IOException, InterruptedException {
        if (!UrlLoader.isValidUrl(fileUrl)) {
            throw new IllegalArgumentException("URL does not match any of the allowed patterns: " + allowedUrlPatterns);
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(fileUrl)).build();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        return response.body();
    }

    public static boolean isValidUrl(String fileUrl) {
        for (String pattern : allowedUrlPatterns) {
            Pattern compiledPattern = Pattern.compile(pattern);
            Matcher matcher = compiledPattern.matcher(fileUrl);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAllowedUrlPatterns() {
        return allowedUrlPatterns;
    }

    public static void setAllowedUrlPatterns(List<String> allowedUrlPatterns) {
        UrlLoader.allowedUrlPatterns = allowedUrlPatterns;
    }

    public static void addAllowedUrlPattern(String allowedUrlPattern) {
        ArrayList<String> current = new ArrayList<String>(allowedUrlPatterns);
        current.add(allowedUrlPattern);
        allowedUrlPatterns = current;
    }

    public static void addAllowedUrlPatterns(List<String> allowedUrlPatterns) {
        ArrayList<String> current = new ArrayList<String>(UrlLoader.allowedUrlPatterns);
        current.addAll(allowedUrlPatterns);
        UrlLoader.allowedUrlPatterns = current;
    }
}

