/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.messaging.MessageHeaders;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaHeaders
implements MessageHeaders {
    private final Headers headers;

    public KafkaHeaders(Headers headers) {
        Objects.requireNonNull(headers, "Argument [headers] cannot be null");
        this.headers = headers;
    }

    public List<String> getAll(CharSequence name) {
        if (name != null) {
            List headers = CollectionUtils.iterableToList((Iterable)this.headers.headers(name.toString()));
            return headers.stream().map(h -> new String(h.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String get(CharSequence name) {
        Header header = this.headers.lastHeader(name.toString());
        if (header != null) {
            return new String(header.value());
        }
        return null;
    }

    public Set<String> names() {
        return Arrays.stream(this.headers.toArray()).map(Header::key).collect(Collectors.toSet());
    }

    public Collection<List<String>> values() {
        return this.names().stream().map(name -> {
            Iterable headers = this.headers.headers(name);
            ArrayList<String> values = new ArrayList<String>();
            for (Header header : headers) {
                values.add(new String(header.value()));
            }
            return values;
        }).collect(Collectors.toList());
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String v = this.get(name);
        if (v != null) {
            return ConversionService.SHARED.convert((Object)v, conversionContext);
        }
        return Optional.empty();
    }

    public KafkaHeaders add(CharSequence header, CharSequence value) {
        if (header != null && value != null) {
            this.headers.add(header.toString(), value.toString().getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    public KafkaHeaders remove(CharSequence header) {
        if (header != null) {
            this.headers.remove(header.toString());
        }
        return this;
    }
}

