/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Map;

public final class KafkaMessage<K, V> {
    private final String topic;
    private final K key;
    private final V body;
    private final Integer partition;
    private final Long timestamp;
    private final Map<String, Object> headers;

    public KafkaMessage(@Nullable String topic, @Nullable K key, @Nullable V body, @Nullable Integer partition, @Nullable Long timestamp, @Nullable Map<String, Object> headers) {
        this.topic = topic;
        this.key = key;
        this.body = body;
        this.partition = partition;
        this.timestamp = timestamp;
        this.headers = headers;
    }

    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @Nullable
    public K getKey() {
        return this.key;
    }

    @Nullable
    public V getBody() {
        return this.body;
    }

    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public static final class Builder<K, V> {
        private String topic;
        private K key;
        private V body;
        private Integer partition;
        private Long timestamp;
        private Map<String, Object> headers;

        @NonNull
        public static <T, F> Builder<T, F> withBody(@Nullable F body) {
            Builder builder = new Builder();
            builder.body = body;
            return builder;
        }

        @NonNull
        public static <T, F> Builder<T, F> withoutBody() {
            Builder builder = new Builder();
            return builder;
        }

        @NonNull
        public Builder<K, V> topic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @NonNull
        public Builder<K, V> key(@Nullable K key) {
            this.key = key;
            return this;
        }

        @NonNull
        public Builder<K, V> body(@Nullable V body) {
            this.body = body;
            return this;
        }

        @NonNull
        public Builder<K, V> header(@Nullable Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        @NonNull
        public Builder<K, V> partition(@Nullable Integer partition) {
            this.partition = partition;
            return this;
        }

        @NonNull
        public Builder<K, V> timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @NonNull
        public KafkaMessage<K, V> build() {
            return new KafkaMessage<K, V>(this.topic, this.key, this.body, this.partition, this.timestamp, this.headers);
        }
    }
}

