/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.bind.ConsumerRecordBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaDefaultBinder<T>
implements ConsumerRecordBinder<T> {
    private final Map<Argument, Function<ConsumerRecord<?, ?>, Object>> defaultResolver = new HashMap();

    public KafkaDefaultBinder() {
        Function<ConsumerRecord, Object> topicFunc = ConsumerRecord::topic;
        Function<ConsumerRecord, Object> offsetFunc = ConsumerRecord::offset;
        Function<ConsumerRecord, Object> partitionFunc = ConsumerRecord::partition;
        Function<ConsumerRecord, Object> timestampFunc = ConsumerRecord::timestamp;
        this.defaultResolver.put(Argument.of(String.class, (String)"topic"), topicFunc);
        this.defaultResolver.put(Argument.of(String.class, (String)"topics"), topicFunc);
        this.defaultResolver.put(Argument.of(Long.class, (String)"offset"), offsetFunc);
        this.defaultResolver.put(Argument.of(Long.class, (String)"offsets"), offsetFunc);
        this.defaultResolver.put(Argument.of(Integer.class, (String)"partition"), partitionFunc);
        this.defaultResolver.put(Argument.of(Integer.class, (String)"partitions"), partitionFunc);
        this.defaultResolver.put(Argument.of(Long.class, (String)"timestamp"), timestampFunc);
        this.defaultResolver.put(Argument.of(Long.class, (String)"timestamps"), timestampFunc);
        this.defaultResolver.put(Argument.of(Long.TYPE, (String)"offset"), offsetFunc);
        this.defaultResolver.put(Argument.of(Long.TYPE, (String)"offsets"), offsetFunc);
        this.defaultResolver.put(Argument.of(Integer.TYPE, (String)"partition"), partitionFunc);
        this.defaultResolver.put(Argument.of(Integer.TYPE, (String)"partitions"), partitionFunc);
        this.defaultResolver.put(Argument.of(Long.TYPE, (String)"timestamp"), timestampFunc);
        this.defaultResolver.put(Argument.of(Long.TYPE, (String)"timestamps"), timestampFunc);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, ConsumerRecord<?, ?> source) {
        Argument argument = context.getArgument();
        Function<ConsumerRecord<?, ?>, Object> f = this.defaultResolver.get(argument);
        if (f != null) {
            Optional<Object> opt = Optional.of(f.apply(source));
            return () -> opt;
        }
        if (argument.getType() == ConsumerRecord.class) {
            Optional<ConsumerRecord<?, ?>> opt = Optional.of(source);
            return () -> opt;
        }
        Object value = source.value();
        Optional converted = ConversionService.SHARED.convert(value, context);
        return () -> converted;
    }
}

