/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.bind.AnnotatedConsumerRecordBinder;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.messaging.annotation.MessageHeader;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;

@Singleton
public class KafkaMessageHeaderBinder<T>
implements AnnotatedConsumerRecordBinder<MessageHeader, T> {
    @Override
    public Class<MessageHeader> annotationType() {
        return MessageHeader.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, ConsumerRecord<?, ?> source) {
        AnnotationMetadata annotationMetadata;
        String name;
        Headers headers = source.headers();
        Iterable value = headers.headers(name = (annotationMetadata = context.getAnnotationMetadata()).stringValue(MessageHeader.class, "name").orElseGet(() -> annotationMetadata.stringValue(MessageHeader.class).orElse(context.getArgument().getName())));
        if (value.iterator().hasNext()) {
            Optional converted = ConversionService.SHARED.convert((Object)value, context);
            return () -> converted;
        }
        if (context.getArgument().getType() == Optional.class) {
            return () -> Optional.of(Optional.empty());
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

