/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.reactor;

import io.micronaut.core.annotation.Internal;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaFuture;
import reactor.core.publisher.Mono;

@Internal
public class KafkaReactorUtil {
    public static <T> Mono<T> fromKafkaFuture(Supplier<KafkaFuture<T>> supplier) {
        return Mono.create(sink -> ((KafkaFuture)supplier.get()).whenComplete((result, error) -> {
            if (error != null) {
                sink.error(error);
            } else if (result != null) {
                sink.success(result);
            } else {
                sink.success();
            }
        }));
    }
}

