/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.tracing;

import io.micronaut.configuration.kafka.tracing.brave.BraveKafkaProducerTracingInstrumentation;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.TracingKafkaProducer;
import jakarta.inject.Singleton;
import org.apache.kafka.clients.producer.Producer;

@Singleton
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={BraveKafkaProducerTracingInstrumentation.class}), @Requires(classes={TracingKafkaProducer.class})})
public class KafkaProducerTracingInstrumentation
implements BeanCreatedEventListener<Producer<?, ?>> {
    private final BeanProvider<Tracer> tracerProvider;

    protected KafkaProducerTracingInstrumentation(BeanProvider<Tracer> tracerProvider) {
        this.tracerProvider = tracerProvider;
    }

    public Producer<?, ?> onCreated(BeanCreatedEvent<Producer<?, ?>> event) {
        Producer kafkaProducer = (Producer)event.getBean();
        if (kafkaProducer instanceof TracingKafkaProducer) {
            return kafkaProducer;
        }
        return new TracingKafkaProducer(kafkaProducer, (Tracer)this.tracerProvider.get());
    }
}

