/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import io.micronaut.context.env.EnvironmentPropertySource;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.SystemPropertiesPropertySource;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.DefaultFileSystemResourceLoader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;

@Singleton
public class ApplicationConfigurationService {
    public static final String DEFAULT_PORT = "8080";
    private final MavenProject mavenProject;
    private final Map<String, Object> applicationConfiguration;

    @Inject
    public ApplicationConfigurationService(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        this.applicationConfiguration = this.parseApplicationConfiguration();
    }

    public String getServerPort() {
        return this.applicationConfiguration.getOrDefault("MICRONAUT_SERVER_PORT", this.applicationConfiguration.getOrDefault("micronaut.server.port", DEFAULT_PORT)).toString();
    }

    private Map<String, Object> parseApplicationConfiguration() {
        MapPropertySource[] propertySources;
        PropertySourceLoader[] loaders;
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (PropertySourceLoader loader : loaders = new PropertySourceLoader[]{new YamlPropertySourceLoader(), new PropertiesPropertySourceLoader()}) {
            Optional optional = loader.load("application", (ResourceLoader)new DefaultFileSystemResourceLoader(new File(this.mavenProject.getBasedir(), "src/main/resources")));
            if (!optional.isPresent()) continue;
            MapPropertySource mapPropertySource = (MapPropertySource)optional.get();
            configuration.putAll(mapPropertySource.asMap());
        }
        for (MapPropertySource mapPropertySource : propertySources = new MapPropertySource[]{new EnvironmentPropertySource(), new SystemPropertiesPropertySource()}) {
            configuration.putAll(mapPropertySource.asMap());
        }
        return configuration;
    }
}

