/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.jib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.cloud.tools.jib.api.Credential;
import io.micronaut.maven.jib.JibConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

@Singleton
public class JibConfigurationService {
    private final Optional<JibConfiguration> configuration;

    @Inject
    public JibConfigurationService(MavenProject mavenProject) {
        Plugin plugin = mavenProject.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (plugin != null && plugin.getConfiguration() != null) {
            XmlMapper mapper = (XmlMapper)((XmlMapper.Builder)((XmlMapper.Builder)XmlMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).findAndAddModules()).build();
            try {
                this.configuration = Optional.ofNullable((JibConfiguration)mapper.readValue(plugin.getConfiguration().toString(), JibConfiguration.class));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error parsing Jib plugin configuration", e);
            }
        } else {
            this.configuration = Optional.empty();
        }
    }

    public Optional<String> getToImage() {
        String value = this.configuration.flatMap(c -> c.to().flatMap(JibConfiguration.ToConfiguration::image)).orElse(null);
        return Optional.ofNullable(System.getProperties().getProperty("jib.to.image", value));
    }

    public Optional<String> getFromImage() {
        String value = this.configuration.flatMap(c -> c.from().flatMap(JibConfiguration.FromConfiguration::image)).orElse(null);
        return Optional.ofNullable(System.getProperties().getProperty("jib.from.image", value));
    }

    public Set<String> getTags() {
        Set tags = this.configuration.flatMap(c -> c.to().map(JibConfiguration.ToConfiguration::tags)).orElse(Collections.emptySet());
        return Optional.ofNullable(System.getProperties().getProperty("jib.to.tags")).map(JibConfigurationService::parseCommaSeparatedList).orElse(tags);
    }

    public Optional<Credential> getToCredentials() {
        String usernameProperty = System.getProperties().getProperty("jib.to.auth.username");
        String passwordProperty = System.getProperties().getProperty("jib.to.auth.password");
        if (usernameProperty != null || passwordProperty != null) {
            return Optional.of(Credential.from((String)usernameProperty, (String)passwordProperty));
        }
        return this.configuration.flatMap(c -> c.to().flatMap(JibConfiguration.ToConfiguration::auth)).map(this::getCredentials);
    }

    public Optional<Credential> getFromCredentials() {
        String usernameProperty = System.getProperties().getProperty("jib.from.auth.username");
        String passwordProperty = System.getProperties().getProperty("jib.from.auth.password");
        if (usernameProperty != null || passwordProperty != null) {
            return Optional.of(Credential.from((String)usernameProperty, (String)passwordProperty));
        }
        return this.configuration.flatMap(c -> c.from().flatMap(JibConfiguration.FromConfiguration::auth)).map(this::getCredentials);
    }

    private Credential getCredentials(JibConfiguration.AuthConfiguration authConfiguration) {
        return Credential.from((String)authConfiguration.username().orElse(null), (String)authConfiguration.password().orElse(null));
    }

    public Optional<String> getWorkingDirectory() {
        String value = this.configuration.flatMap(c -> c.container().flatMap(JibConfiguration.ContainerConfiguration::workingDirectory)).orElse(null);
        return Optional.ofNullable(System.getProperties().getProperty("jib.container.workingDirectory", value));
    }

    public List<String> getArgs() {
        List args = this.configuration.flatMap(c -> c.container().map(JibConfiguration.ContainerConfiguration::args)).orElse(Collections.emptyList());
        return Optional.ofNullable(System.getProperties().getProperty("jib.container.args")).map(JibConfigurationService::parseCommaSeparatedList).map(List::copyOf).orElse(args);
    }

    public Optional<String> getPorts() {
        Set ports = this.configuration.flatMap(c -> c.container().map(JibConfiguration.ContainerConfiguration::ports)).orElse(Collections.emptySet());
        return Optional.ofNullable(System.getProperties().getProperty("jib.container.ports")).map(s -> s.replace(",", " ")).or(() -> ports.isEmpty() ? Optional.empty() : Optional.of(String.join((CharSequence)" ", ports)));
    }

    private static Set<String> parseCommaSeparatedList(String list) {
        String[] parts = list.split(",");
        HashSet<String> items = new HashSet<String>(parts.length);
        for (String part : parts) {
            items.add(part.trim());
        }
        return items;
    }
}

