/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import io.micronaut.maven.AbstractDockerMojo;
import io.micronaut.maven.core.MicronautRuntime;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;

@Mojo(name="docker-crac", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerCracMojo
extends AbstractDockerMojo {
    public static final String DOCKER_CRAC_PACKAGING = "docker-crac";
    public static final String CHECKPOINT_SCRIPT_NAME = "checkpoint.sh";
    public static final String WARMUP_SCRIPT_NAME = "warmup.sh";
    public static final String RUN_SCRIPT_NAME = "run.sh";
    public static final String DEFAULT_READINESS_COMMAND = "curl --output /dev/null --silent --head http://localhost:8080";
    public static final String CRAC_READINESS_PROPERTY = "crac.readiness";
    public static final String DEFAULT_CRAC_CHECKPOINT_TIMEOUT = "60";
    public static final String CRAC_CHECKPOINT_NETWORK_PROPERTY = "crac.checkpoint.network";
    public static final String CRAC_CHECKPOINT_TIMEOUT_PROPERTY = "crac.checkpoint.timeout";
    public static final String CRAC_JAVA_VERSION = "crac.java.version";
    public static final String CRAC_ARCHITECTURE = "crac.arch";
    public static final String CRAC_OS = "crac.os";
    public static final String DEFAULT_CRAC_OS = "linux-glibc";
    public static final String DEFAULT_BASE_IMAGE = "ubuntu:22.04";
    public static final String ARM_ARCH = "aarch64";
    public static final String X86_64_ARCH = "amd64";
    private static final EnumSet<PosixFilePermission> POSIX_FILE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
    private final MavenReaderFilter mavenReaderFilter;
    @Parameter(property="crac.readiness", defaultValue="curl --output /dev/null --silent --head http://localhost:8080")
    private String readinessCommand;
    @Parameter(property="crac.checkpoint.timeout", defaultValue="60")
    private Integer checkpointTimeoutSeconds;
    @Parameter(property="crac.checkpoint.network")
    private String checkpointNetworkName;
    @Parameter(property="crac.java.version", defaultValue="${jdk.version}")
    private String cracJavaVersion;
    @Parameter(property="crac.arch")
    private String cracArchitecture;
    @Parameter(property="crac.os", defaultValue="linux-glibc")
    private String cracOs;

    @Inject
    public DockerCracMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService, MavenReaderFilter mavenReaderFilter, MavenSession mavenSession, MojoExecution mojoExecution) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService, mavenSession, mojoExecution);
        this.mavenReaderFilter = mavenReaderFilter;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.copyDependencies();
            MicronautRuntime runtime = MicronautRuntime.valueOf((String)this.micronautRuntime.toUpperCase());
            switch (runtime.getBuildStrategy()) {
                case LAMBDA: {
                    throw new MojoExecutionException("Lambda Functions are currently unsupported");
                }
                case ORACLE_FUNCTION: {
                    throw new MojoExecutionException("Oracle Functions are currently unsupported");
                }
                case DEFAULT: {
                    this.buildDockerCrac();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(runtime.getBuildStrategy()));
                }
            }
        }
        catch (InvalidImageReferenceException iire) {
            String message = "Invalid image reference " + iire.getInvalidReference() + ", perhaps you should check that the reference is formatted correctly according to https://docs.docker.com/engine/reference/commandline/tag/#extended-description\nFor example, slash-separated name components cannot have uppercase letters";
            throw new MojoExecutionException(message);
        }
        catch (IOException | IllegalArgumentException | MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void buildDockerCrac() throws IOException, InvalidImageReferenceException, MavenFilteringException {
        String checkpointImage = this.buildCheckpointDockerfile();
        this.getLog().info((CharSequence)("CRaC Checkpoint image: " + checkpointImage));
        File checkpointDir = new File(this.mavenProject.getBuild().getDirectory(), "cr");
        checkpointDir.mkdirs();
        this.dockerService.runPrivilegedImageAndWait(checkpointImage, this.checkpointTimeoutSeconds, this.checkpointNetworkName, checkpointDir.getAbsolutePath() + ":/home/app/cr");
        this.buildFinalDockerfile(checkpointImage);
    }

    private String limitArchitecture(String architecture) {
        if (architecture == null) {
            return null;
        }
        if (ARM_ARCH.equals(architecture)) {
            return architecture;
        }
        return X86_64_ARCH;
    }

    private String buildCheckpointDockerfile() throws IOException, MavenFilteringException {
        String name = this.mavenProject.getArtifactId() + "-crac-checkpoint";
        Set<CallSite> checkpointTags = Collections.singleton(name);
        this.copyScripts(CHECKPOINT_SCRIPT_NAME, WARMUP_SCRIPT_NAME, RUN_SCRIPT_NAME);
        File dockerfile = this.dockerService.loadDockerfileAsResource("DockerfileCracCheckpoint");
        String systemArchitecture = this.limitArchitecture(System.getProperty("os.arch"));
        String filteredCracArchitecture = this.limitArchitecture(this.cracArchitecture);
        String finalArchitecture = filteredCracArchitecture == null ? systemArchitecture : filteredCracArchitecture;
        String baseImage = this.getFromImage().orElse(DEFAULT_BASE_IMAGE);
        this.getLog().info((CharSequence)("Using BASE_IMAGE: " + baseImage));
        this.getLog().info((CharSequence)("Using CRAC_ARCH: " + finalArchitecture));
        this.getLog().info((CharSequence)("Using CRAC_JDK_VERSION: " + this.cracJavaVersion));
        this.getLog().info((CharSequence)("Using CRAC_OS: " + this.cracOs));
        BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd().withDockerfile(dockerfile).withBuildArg("BASE_IMAGE", baseImage).withBuildArg("CRAC_ARCH", finalArchitecture).withBuildArg("CRAC_OS", this.cracOs).withBuildArg("CRAC_JDK_VERSION", this.cracJavaVersion).withTags(checkpointTags);
        this.getNetworkMode().ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withNetworkMode(arg_0));
        this.dockerService.buildImage(buildImageCmd);
        return name;
    }

    private void buildFinalDockerfile(String checkpointContainerId) throws IOException, InvalidImageReferenceException, MavenFilteringException {
        Set<String> tags = this.getTags();
        for (String tag : tags) {
            ImageReference.parse((String)tag);
        }
        String ports = this.getPorts();
        this.getLog().info((CharSequence)("Exposing port(s): " + ports));
        this.copyScripts(RUN_SCRIPT_NAME);
        File dockerfile = this.dockerService.loadDockerfileAsResource("DockerfileCrac");
        String baseImage = this.getFromImage().orElse(DEFAULT_BASE_IMAGE);
        this.getLog().info((CharSequence)("Using BASE_IMAGE: " + baseImage));
        this.getLog().info((CharSequence)("Using CHECKPOINT_IMAGE: " + checkpointContainerId));
        BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd().withDockerfile(dockerfile).withBuildArg("PORTS", ports).withBuildArg("BASE_IMAGE", this.getFromImage().orElse(DEFAULT_BASE_IMAGE)).withBuildArg("CHECKPOINT_IMAGE", checkpointContainerId).withTags(this.getTags());
        this.getNetworkMode().ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withNetworkMode(arg_0));
        this.dockerService.buildImage(buildImageCmd);
        this.getLog().warn((CharSequence)"**********************************************************");
        this.getLog().warn((CharSequence)" CRaC checkpoint files may contain sensitive information.");
        this.getLog().warn((CharSequence)"**********************************************************");
    }

    private Properties replacementProperties(String readinessCommand, String mainClass) {
        Properties properties = new Properties();
        properties.setProperty("READINESS", readinessCommand);
        properties.setProperty("MAINCLASS", mainClass);
        return properties;
    }

    private void copyScripts(String ... scriptNames) throws IOException, MavenFilteringException {
        File target = new File(this.mavenProject.getBuild().getDirectory(), "scripts");
        if (!target.exists()) {
            target.mkdirs();
        }
        this.processScripts(target, this.replacementProperties(this.readinessCommand, this.mainClass), scriptNames);
    }

    private void processScripts(File target, Properties replacements, String ... scriptNames) throws IOException, MavenFilteringException {
        for (String script : scriptNames) {
            File localOverride = new File(this.mavenProject.getBasedir(), script);
            InputStream resourceStream = DockerCracMojo.class.getResourceAsStream("/cracScripts/" + script);
            InputStreamReader resourceReader = resourceStream == null ? null : new InputStreamReader(resourceStream);
            try (InputStreamReader reader = localOverride.exists() ? Files.newBufferedReader(localOverride.toPath()) : resourceReader;){
                if (reader == null) {
                    throw new IOException("Could not find script " + script);
                }
                MavenReaderFilterRequest req = new MavenReaderFilterRequest();
                req.setFrom((Reader)reader);
                req.setFiltering(true);
                req.setAdditionalProperties(replacements);
                Path outputPath = target.toPath().resolve(script);
                try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    IOUtils.copy((Reader)this.mavenReaderFilter.filter(req), (Writer)writer);
                }
                Files.setPosixFilePermissions(outputPath, POSIX_FILE_PERMISSIONS);
            }
        }
    }
}

